/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.rahas.impl.util.SAML2KeyInfo;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SAML2Utils {
    private static final Log log = LogFactory.getLog(SAML2Utils.class);

    public static Element getElementFromAssertion(XMLObject xmlObj) throws TrustException {
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(xmlObj);
            Element assertionElement = marshaller.marshall(xmlObj, ((DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom")).newDocumentBuilderFactory().newDocumentBuilder().newDocument());
            log.debug((Object)"DOM element is created successfully from the OpenSAML2 XMLObject");
            return assertionElement;
        }
        catch (Exception e) {
            throw new TrustException("Error creating DOM object from the assertion", e);
        }
    }

    public static SAML2KeyInfo getSAML2KeyInfo(Element elem, Crypto crypto, CallbackHandler cb, RequestData requestData) throws WSSecurityException {
        Assertion assertion;
        try {
            InitializationService.initialize();
            String keyInfoElementString = elem.toString();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(keyInfoElementString.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            assertion = (Assertion)unmarshaller.unmarshall(element);
        }
        catch (InitializationException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "Failure in bootstrapping");
        }
        catch (UnmarshallingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "Failure in unmarshelling the assertion");
        }
        catch (IOException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "Failure in unmarshelling the assertion");
        }
        catch (SAXException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "Failure in unmarshelling the assertion");
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)e, "Failure in unmarshelling the assertion");
        }
        return SAML2Utils.getSAML2KeyInfo(assertion, crypto, cb, requestData);
    }

    public static SAML2KeyInfo getSAML2KeyInfo(Assertion assertion, Crypto crypto, CallbackHandler cb, RequestData requestData) throws WSSecurityException {
        byte[] key;
        WSPasswordCallback pwcb = new WSPasswordCallback(assertion.getID(), 7);
        if (cb != null) {
            try {
                cb.handle(new Callback[]{pwcb});
            }
            catch (Exception e1) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e1, "noKey");
            }
        }
        if ((key = pwcb.getKey()) != null) {
            return new SAML2KeyInfo(assertion, key);
        }
        try {
            AuthnStatement authnStmt;
            Element keyInfoElement;
            Subject samlSubject = assertion.getSubject();
            if (samlSubject == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAML2Token", new Object[]{"for Signature (no Subject)"});
            }
            SubjectConfirmation subjectConf = (SubjectConfirmation)samlSubject.getSubjectConfirmations().get(0);
            if (subjectConf == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation)"});
            }
            SubjectConfirmationData scData = subjectConf.getSubjectConfirmationData();
            if (scData == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAML2Token", new Object[]{"for Signature (no Subject Confirmation Data)"});
            }
            XMLObject KIElem = null;
            List scDataElements = scData.getOrderedChildren();
            for (XMLObject xmlObj : scDataElements) {
                if (!(xmlObj instanceof org.opensaml.xmlsec.signature.KeyInfo)) continue;
                KIElem = xmlObj;
                break;
            }
            if (KIElem != null) {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(KIElem);
                try {
                    keyInfoElement = marshaller.marshall(KIElem, ((DOMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom")).newDocumentBuilderFactory().newDocumentBuilder().newDocument());
                }
                catch (ParserConfigurationException ex) {
                    throw new Error(ex);
                }
            } else {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAML2Token", new Object[]{"for Signature (no key info element)"});
            }
            AttributeStatement attrStmt = assertion.getAttributeStatements().size() != 0 ? (AttributeStatement)assertion.getAttributeStatements().get(0) : null;
            AuthnStatement authnStatement = authnStmt = assertion.getAuthnStatements().size() != 0 ? (AuthnStatement)assertion.getAuthnStatements().get(0) : null;
            if (attrStmt != null) {
                NodeList children = keyInfoElement.getChildNodes();
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    QName el = new QName(child.getNamespaceURI(), child.getLocalName());
                    if (el.equals(WSConstants.ENCRYPTED_KEY)) {
                        byte[] secret = CommonUtil.getDecryptedBytes(cb, crypto, child, requestData);
                        return new SAML2KeyInfo(assertion, secret);
                    }
                    if (!el.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "BinarySecret"))) continue;
                    Text txt = (Text)child.getFirstChild();
                    return new SAML2KeyInfo(assertion, Base64.getDecoder().decode(txt.getData()));
                }
            }
            if (authnStmt != null) {
                try {
                    KeyInfo ki = new KeyInfo(keyInfoElement, null);
                    if (ki.containsX509Data()) {
                        X509Data data = ki.itemX509Data(0);
                        XMLX509Certificate certElem = null;
                        if (data != null && data.containsCertificate()) {
                            certElem = data.itemCertificate(0);
                        }
                        if (certElem != null) {
                            X509Certificate cert = certElem.getX509Certificate();
                            X509Certificate[] certs = new X509Certificate[]{cert};
                            return new SAML2KeyInfo(assertion, certs);
                        }
                    }
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e3), "invalidSAMLsecurity", new Object[]{"cannot get certificate (key holder)"});
                }
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity", new Object[]{"cannot get certificate or key "});
        }
        catch (MarshallingException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, (Exception)((Object)e), "Failed marshalling the SAML Assertion", null);
        }
    }

    public static String getSAML2SubjectConfirmationMethod(Assertion assertion) {
        String subjectConfirmationMethod = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
        List subjectConfirmations = assertion.getSubject().getSubjectConfirmations();
        if (subjectConfirmations.size() > 0) {
            subjectConfirmationMethod = ((SubjectConfirmation)subjectConfirmations.get(0)).getMethod();
        }
        return subjectConfirmationMethod;
    }

    public static Assertion createAssertion() throws TrustException {
        try {
            Assertion assertion = (Assertion)CommonUtil.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
            assertion.setVersion(SAMLVersion.VERSION_20);
            assertion.setID(UUID.randomUUID().toString());
            return assertion;
        }
        catch (TrustException e) {
            throw new TrustException("Unable to create an Assertion object: " + e.getMessage(), e);
        }
    }

    public static Issuer createIssuer(String issuerName) throws TrustException {
        try {
            Issuer issuer = (Issuer)CommonUtil.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
            issuer.setValue(issuerName);
            return issuer;
        }
        catch (TrustException e) {
            throw new TrustException("Unable to create an Issuer object", e);
        }
    }

    public static Conditions createConditions(Instant creationTime, Instant expirationTime) throws TrustException {
        try {
            Conditions conditions = (Conditions)CommonUtil.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
            conditions.setNotBefore(creationTime);
            conditions.setNotOnOrAfter(expirationTime);
            return conditions;
        }
        catch (TrustException e) {
            throw new TrustException("Unable to create an Conditions object");
        }
    }

    public static NameID createNamedIdentifier(String principalName, String format) throws TrustException {
        NameID nameId = (NameID)CommonUtil.buildXMLObject(NameID.DEFAULT_ELEMENT_NAME);
        nameId.setValue(principalName);
        nameId.setFormat(format);
        return nameId;
    }
}

