/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Axis2Util {
    private static ThreadLocal doomTacker = new ThreadLocal();

    public static boolean isUseDOOM() {
        Object value = doomTacker.get();
        return value != null;
    }

    public static void useDOOM(boolean isDOOMRequired) {
    }

    public static Document getDocumentFromSOAPEnvelope(SOAPEnvelope env, boolean useDoom) throws WSSecurityException {
        try {
            if (env instanceof Element) {
                Element element = (Element)env;
                Document document = element.getOwnerDocument();
                if (element.getParentNode() != document) {
                    document.appendChild(element);
                }
                DOMConfiguration domConfig = document.getDomConfig();
                domConfig.setParameter("split-cdata-sections", Boolean.FALSE);
                domConfig.setParameter("well-formed", Boolean.FALSE);
                domConfig.setParameter("namespaces", Boolean.TRUE);
                document.normalizeDocument();
                return document;
            }
            if (useDoom) {
                env.build();
                OMElement firstElement = env.getBody().getFirstElement();
                if (firstElement != null) {
                    firstElement.build();
                }
                SOAPHeader soapHeader = env.getHeader();
                ArrayList<QName> processedHeaderQNames = new ArrayList<QName>();
                if (soapHeader != null) {
                    Iterator headerBlocs = soapHeader.getChildElements();
                    while (headerBlocs.hasNext()) {
                        SOAPHeaderBlock element = (SOAPHeaderBlock)headerBlocs.next();
                        if (!element.isProcessed()) continue;
                        processedHeaderQNames.add(element.getQName());
                    }
                }
                SOAPModelBuilder stAXSOAPModelBuilder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((OMMetaFactory)OMAbstractFactory.getMetaFactory((String)"dom"), (XMLStreamReader)env.getXMLStreamReader());
                SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                envelope.getParent().build();
                SOAPHeader header = envelope.getHeader();
                for (QName name : processedHeaderQNames) {
                    Iterator omKids = header.getHeaderBlocksWithName(name);
                    if (!omKids.hasNext()) continue;
                    ((SOAPHeaderBlock)omKids.next()).setProcessed();
                }
                Element envElem = (Element)envelope;
                return envElem.getOwnerDocument();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            env.build();
            env.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(bais);
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Error in converting SOAP Envelope to Document: " + e.getMessage());
        }
    }

    public static SOAPEnvelope getSOAPEnvelopeFromDOMDocument(Document doc, boolean useDoom) throws WSSecurityException {
        SOAPEnvelope env;
        Element documentElement = doc.getDocumentElement();
        if (documentElement instanceof SOAPEnvelope && (env = (SOAPEnvelope)documentElement).getOMFactory().getMetaFactory() == OMAbstractFactory.getMetaFactory()) {
            return env;
        }
        if (useDoom) {
            try {
                env = (SOAPEnvelope)doc.getDocumentElement();
                ArrayList<QName> processedHeaderQNames = new ArrayList<QName>();
                SOAPHeader soapHeader = env.getHeader();
                if (soapHeader != null) {
                    Iterator headerBlocs = soapHeader.getChildElements();
                    while (headerBlocs.hasNext()) {
                        OMElement element = (OMElement)headerBlocs.next();
                        SOAPHeaderBlock header = null;
                        if (element instanceof SOAPHeaderBlock) {
                            header = (SOAPHeaderBlock)element;
                        } else {
                            header = soapHeader.addHeaderBlock(element.getLocalName(), element.getNamespace());
                            Iterator attrIter = element.getAllAttributes();
                            while (attrIter.hasNext()) {
                                OMAttribute attr = (OMAttribute)attrIter.next();
                                header.addAttribute(attr.getLocalName(), attr.getAttributeValue(), attr.getNamespace());
                            }
                            Iterator nsIter = element.getAllDeclaredNamespaces();
                            while (nsIter.hasNext()) {
                                OMNamespace ns = (OMNamespace)nsIter.next();
                                header.declareNamespace(ns);
                            }
                            Iterator children = element.getChildren();
                            while (children.hasNext()) {
                                OMNode child = (OMNode)children.next();
                                children.remove();
                                header.addChild(child);
                            }
                            headerBlocs.remove();
                            soapHeader.build();
                            header.setProcessed();
                        }
                        if (!header.isProcessed()) continue;
                        processedHeaderQNames.add(element.getQName());
                    }
                }
                XMLStreamReader reader = ((OMElement)doc.getDocumentElement()).getXMLStreamReader();
                SOAPModelBuilder stAXSOAPModelBuilder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)reader);
                SOAPEnvelope envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                SOAPHeader header = envelope.getHeader();
                for (QName name : processedHeaderQNames) {
                    Iterator omKids = header.getHeaderBlocksWithName(name);
                    if (!omKids.hasNext()) continue;
                    ((SOAPHeaderBlock)omKids.next()).setProcessed();
                }
                envelope.build();
                return envelope;
            }
            catch (FactoryConfigurationError e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e.getMessage());
            }
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLUtils.outputDOM((Node)doc.getDocumentElement(), (OutputStream)os, (boolean)true);
            ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());
            SOAPModelBuilder stAXSOAPModelBuilder = OMXMLBuilderFactory.createSOAPModelBuilder((InputStream)bais, null);
            return stAXSOAPModelBuilder.getSOAPEnvelope();
        }
        catch (Exception e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
        }
    }

    public static String getKey(String originalKey, boolean inHandler, int repetition) {
        if (!(repetition <= 0 || inHandler || originalKey.equals("OutflowSecurity") || originalKey.equals("senderRepeatCount"))) {
            return originalKey + repetition;
        }
        return originalKey;
    }

    public static OMElement toDOOM(OMFactory factory, OMElement element) {
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)factory, (XMLStreamReader)element.getXMLStreamReader());
        OMElement elem = builder.getDocumentElement();
        elem.build();
        return elem;
    }
}

