/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.watch.WatchesPathReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WatchesPathReportTest
extends ZKTestCase {
    private Map<String, Set<Long>> m;
    private WatchesPathReport r;

    @BeforeEach
    public void setUp() {
        this.m = new HashMap<String, Set<Long>>();
        HashSet<Long> s = new HashSet<Long>();
        s.add(101L);
        s.add(102L);
        this.m.put("path1", s);
        s = new HashSet();
        s.add(201L);
        this.m.put("path2", s);
        this.r = new WatchesPathReport(this.m);
    }

    @Test
    public void testHasSessions() {
        Assertions.assertTrue((boolean)this.r.hasSessions("path1"));
        Assertions.assertTrue((boolean)this.r.hasSessions("path2"));
        Assertions.assertFalse((boolean)this.r.hasSessions("path3"));
    }

    @Test
    public void testGetSessions() {
        Set s = this.r.getSessions("path1");
        Assertions.assertEquals((int)2, (int)s.size());
        Assertions.assertTrue((boolean)s.contains(101L));
        Assertions.assertTrue((boolean)s.contains(102L));
        s = this.r.getSessions("path2");
        Assertions.assertEquals((int)1, (int)s.size());
        Assertions.assertTrue((boolean)s.contains(201L));
        Assertions.assertNull((Object)this.r.getSessions("path3"));
    }

    @Test
    public void testToMap() {
        Assertions.assertEquals(this.m, (Object)this.r.toMap());
    }
}

