/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.namespace;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.exceptions.NamespaceExistsException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.AdminCommand;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class CreateNamespaceCommand
extends AdminCommand<Flags> {
    private static final String NAME = "create";
    private static final String DESC = "Create a namespace";

    public CreateNamespaceCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<namespace-name>").build());
    }

    @Override
    protected void run(StorageAdminClient admin, BKFlags globalFlags, Flags flags) throws Exception {
        Preconditions.checkArgument((!flags.arguments.isEmpty() ? 1 : 0) != 0, (Object)"Namespace name is not provided");
        String namespaceName = (String)flags.arguments.get(0);
        try {
            NamespaceProperties nsProps = (NamespaceProperties)FutureUtils.result((CompletableFuture)admin.createNamespace(namespaceName, NamespaceConfiguration.newBuilder().setDefaultStreamConf(ProtocolConstants.DEFAULT_STREAM_CONF).build()));
            this.spec.console().println("Successfully created namespace '" + namespaceName + "':");
            this.spec.console().println(nsProps);
        }
        catch (NamespaceExistsException nee) {
            this.spec.console().println("Namespace '" + namespaceName + "' already exists");
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

