/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.GetDataRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestRecord;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.zookeeper.server.quorum.UpgradeableSessionTracker;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiOpSessionUpgradeTest
extends QuorumBase {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiOpSessionUpgradeTest.class);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.localSessionsEnabled = true;
        this.localSessionsUpgradingEnabled = true;
        super.setUp();
    }

    @Test
    public void ephemeralCreateMultiOpTest() throws KeeperException, InterruptedException, IOException {
        TestableZooKeeper zk = this.createClient();
        String data = "test";
        String path = "/ephemeralcreatemultiop";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assertions.assertNotNull((Object)server, (String)"unable to find server interlocutor");
        UpgradeableSessionTracker sessionTracker = (UpgradeableSessionTracker)server.getSessionTracker();
        Assertions.assertFalse((boolean)sessionTracker.isGlobalSession(zk.getSessionId()), (String)"session already global");
        List multi = null;
        try {
            multi = zk.multi(Arrays.asList(Op.setData((String)path, (byte[])data.getBytes(), (int)0), Op.create((String)(path + "/e"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL), Op.create((String)(path + "/p"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT), Op.create((String)(path + "/q"), (byte[])data.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.EPHEMERAL)));
        }
        catch (KeeperException.SessionExpiredException e) {
            Assertions.fail((String)"received session expired for a session promotion in a multi-op");
        }
        Assertions.assertNotNull(multi);
        Assertions.assertEquals((int)4, (int)multi.size());
        Assertions.assertEquals((Object)data, (Object)new String(zk.getData(path + "/e", false, null)));
        Assertions.assertEquals((Object)data, (Object)new String(zk.getData(path + "/p", false, null)));
        Assertions.assertEquals((Object)data, (Object)new String(zk.getData(path + "/q", false, null)));
        Assertions.assertTrue((boolean)sessionTracker.isGlobalSession(zk.getSessionId()), (String)"session not promoted");
    }

    @Test
    public void directCheckUpgradeSessionTest() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/directcheckupgradesession";
        zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        QuorumZooKeeperServer server = this.getConnectedServer(zk.getSessionId());
        Assertions.assertNotNull((Object)server, (String)"unable to find server interlocutor");
        Request readRequest = this.makeGetDataRequest(path, zk.getSessionId());
        Request createRequest = this.makeCreateRequest(path + "/e", zk.getSessionId());
        Assertions.assertNull((Object)server.checkUpgradeSession(readRequest), (String)"tried to upgrade on a read");
        Assertions.assertNotNull((Object)server.checkUpgradeSession(createRequest), (String)"failed to upgrade on a create");
        Assertions.assertNull((Object)server.checkUpgradeSession(createRequest), (String)"tried to upgrade after successful promotion");
    }

    private Request makeGetDataRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        GetDataRequest getDataRequest = new GetDataRequest(path, false);
        getDataRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 4, RequestRecord.fromBytes((ByteBuffer)bb), new ArrayList());
    }

    private Request makeCreateRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        CreateRequest createRequest = new CreateRequest(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL.toFlag());
        createRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 15, RequestRecord.fromBytes((ByteBuffer)bb), new ArrayList());
    }

    private QuorumZooKeeperServer getConnectedServer(long sessionId) {
        for (QuorumPeer peer : this.getPeerList()) {
            if (!peer.getActiveServer().getSessionTracker().isTrackingSession(sessionId)) continue;
            return (QuorumZooKeeperServer)peer.getActiveServer();
        }
        return null;
    }
}

