/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.util.ConfigUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConfigUtilsTest {
    @Test
    public void testGetHostAndPortWithIPv6() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:443");
        Assertions.assertEquals((Object)nsa[0], (Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348");
        Assertions.assertEquals((Object)nsa[1], (Object)"443");
        nsa = ConfigUtils.getHostAndPort((String)"[2001:db8:1::242:ac11:2]:2888:3888");
        Assertions.assertEquals((Object)nsa[0], (Object)"2001:db8:1::242:ac11:2");
        Assertions.assertEquals((Object)nsa[1], (Object)"2888");
        Assertions.assertEquals((Object)nsa[2], (Object)"3888");
    }

    @Test
    public void testGetHostAndPortWithIPv4() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort((String)"127.0.0.1:443");
        Assertions.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assertions.assertEquals((Object)nsa[1], (Object)"443");
        nsa = ConfigUtils.getHostAndPort((String)"127.0.0.1:2888:3888");
        Assertions.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assertions.assertEquals((Object)nsa[1], (Object)"2888");
        Assertions.assertEquals((Object)nsa[2], (Object)"3888");
    }

    @Test
    public void testGetHostAndPortWithoutBracket() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> {
            String[] nsa = ConfigUtils.getHostAndPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348");
        });
    }

    @Test
    public void testGetHostAndPortWithoutPortAfterColon() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> {
            String[] nsa = ConfigUtils.getHostAndPort((String)"[2001:db8:1::242:ac11:2]:");
        });
    }

    @Test
    public void testGetHostAndPortWithoutPort() throws QuorumPeerConfig.ConfigException {
        String[] nsa = ConfigUtils.getHostAndPort((String)"127.0.0.1");
        Assertions.assertEquals((Object)nsa[0], (Object)"127.0.0.1");
        Assertions.assertEquals((int)nsa.length, (int)1);
        nsa = ConfigUtils.getHostAndPort((String)"[2001:db8:1::242:ac11:2]");
        Assertions.assertEquals((Object)nsa[0], (Object)"2001:db8:1::242:ac11:2");
        Assertions.assertEquals((int)nsa.length, (int)1);
    }

    @Test
    public void testGetPropertyBackwardCompatibleWay() throws QuorumPeerConfig.ConfigException {
        String newProp = "zookeeper.prop.x.y.z";
        String oldProp = "prop.x.y.z";
        String result = ConfigUtils.getPropertyBackwardCompatibleWay((String)newProp);
        Assertions.assertNull((Object)result);
        String oldPropValue = "oldPropertyValue";
        System.setProperty(oldProp, oldPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay((String)newProp);
        Assertions.assertEquals((Object)oldPropValue, (Object)result);
        String newPropValue = "newPropertyValue";
        System.setProperty(newProp, newPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay((String)newProp);
        Assertions.assertEquals((Object)newPropValue, (Object)result);
        this.clearProp(newProp, oldProp);
        System.setProperty(oldProp, oldPropValue + "  ");
        result = ConfigUtils.getPropertyBackwardCompatibleWay((String)newProp);
        Assertions.assertEquals((Object)oldPropValue, (Object)result);
        System.setProperty(newProp, "  " + newPropValue);
        result = ConfigUtils.getPropertyBackwardCompatibleWay((String)newProp);
        Assertions.assertEquals((Object)newPropValue, (Object)result);
        this.clearProp(newProp, oldProp);
    }

    private void clearProp(String newProp, String oldProp) {
        System.clearProperty(newProp);
        System.clearProperty(oldProp);
    }
}

