/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.RequestRecord;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.WorkerService;
import org.apache.zookeeper.server.quorum.CommitProcessor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitProcessorMetricsTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(CommitProcessorMetricsTest.class);
    CommitProcessor commitProcessor;
    DummyFinalProcessor finalProcessor;
    CountDownLatch requestScheduled = null;
    CountDownLatch requestProcessed = null;
    CountDownLatch commitSeen = null;
    CountDownLatch poolEmpytied = null;

    @BeforeEach
    public void setup() {
        LOG.info("setup");
        ServerMetrics.getMetrics().resetAll();
        System.clearProperty("zookeeper.commitProcessor.maxReadBatchSize");
        System.clearProperty("zookeeper.commitProcessor.maxCommitBatchSize");
    }

    public void setupProcessors(int commitWorkers, int finalProcTime) {
        this.finalProcessor = new DummyFinalProcessor(finalProcTime);
        this.commitProcessor = new TestCommitProcessor(this.finalProcessor, commitWorkers);
        this.commitProcessor.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("tearDown starting");
        this.commitProcessor.shutdown();
        this.commitProcessor.join();
    }

    private void checkMetrics(String metricName, long min, long max, double avg, long cnt, long sum) {
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)min, (Object)values.get("min_" + metricName), (String)("expected min is " + min));
        Assertions.assertEquals((Object)max, (Object)values.get("max_" + metricName), (String)("expected max is: " + max));
        Assertions.assertEquals((double)avg, (double)((Double)values.get("avg_" + metricName)), (double)0.001, (String)("expected avg is: " + avg));
        Assertions.assertEquals((Object)cnt, (Object)values.get("cnt_" + metricName), (String)("expected cnt is: " + cnt));
        Assertions.assertEquals((Object)sum, (Object)values.get("sum_" + metricName), (String)("expected sum is: " + sum));
    }

    private void checkTimeMetric(long actual, long lBoundrary, long hBoundrary) {
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(lBoundrary)));
        MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(hBoundrary)));
    }

    private Request createReadRequest(long sessionId, int xid) {
        return new Request(null, sessionId, xid, 4, RequestRecord.fromBytes((byte[])new byte[10]), null);
    }

    private Request createWriteRequest(long sessionId, int xid) {
        return new Request(null, sessionId, xid, 5, RequestRecord.fromBytes((byte[])new byte[10]), null);
    }

    private void processRequestWithWait(Request request) throws Exception {
        this.requestProcessed = new CountDownLatch(1);
        this.commitProcessor.processRequest(request);
        this.requestProcessed.await(5L, TimeUnit.SECONDS);
    }

    private void commitWithWait(Request request) throws Exception {
        this.requestProcessed = new CountDownLatch(1);
        this.commitProcessor.commit(request);
        this.requestProcessed.await(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testRequestsInSessionQueue() throws Exception {
        this.setupProcessors(0, 0);
        Request req1 = this.createWriteRequest(1L, 1);
        this.processRequestWithWait(req1);
        this.checkMetrics("requests_in_session_queue", 1L, 1L, 1.0, 1L, 1L);
        this.processRequestWithWait(this.createReadRequest(1L, 2));
        this.processRequestWithWait(this.createReadRequest(1L, 3));
        this.checkMetrics("requests_in_session_queue", 1L, 3L, 2.0, 3L, 6L);
        this.commitWithWait(req1);
        this.checkMetrics("requests_in_session_queue", 1L, 3L, 2.25, 4L, 9L);
    }

    @Test
    public void testWriteFinalProcTime() throws Exception {
        this.setupProcessors(0, 1000);
        Request req1 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req1);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)0L, (Object)values.get("cnt_write_final_proc_time_ms"));
        this.commitWithWait(req1);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_write_final_proc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_write_final_proc_time_ms"), 1000L, 2000L);
    }

    @Test
    public void testReadFinalProcTime() throws Exception {
        this.setupProcessors(0, 1000);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_read_final_proc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_read_final_proc_time_ms"), 1000L, 2000L);
    }

    @Test
    public void testCommitProcessTime() throws Exception {
        this.setupProcessors(0, 0);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_commit_process_time"));
        this.checkTimeMetric((Long)values.get("max_commit_process_time"), 0L, 1000L);
    }

    @Test
    public void testServerWriteCommittedTime() throws Exception {
        this.setupProcessors(0, 0);
        this.commitWithWait(this.createWriteRequest(1L, 1));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_server_write_committed_time_ms"));
        this.checkTimeMetric((Long)values.get("max_server_write_committed_time_ms"), 0L, 1000L);
    }

    @Test
    public void testLocalWriteCommittedTime() throws Exception {
        this.setupProcessors(0, 0);
        Request req1 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req1);
        this.commitWithWait(req1);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_local_write_committed_time_ms"));
        this.checkTimeMetric((Long)values.get("max_local_write_committed_time_ms"), 0L, 1000L);
        Request req2 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req2);
        Thread.sleep(1000L);
        this.commitWithWait(req2);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)2L, (Object)values.get("cnt_local_write_committed_time_ms"));
        this.checkTimeMetric((Long)values.get("max_local_write_committed_time_ms"), 0L, 1000L);
    }

    @Test
    public void testWriteCommitProcTime() throws Exception {
        this.setupProcessors(0, 0);
        Request req1 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req1);
        this.commitWithWait(req1);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_write_commitproc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_write_commitproc_time_ms"), 0L, 1000L);
        Request req2 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req2);
        Thread.sleep(1000L);
        this.commitWithWait(req2);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)2L, (Object)values.get("cnt_write_commitproc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_write_commitproc_time_ms"), 1000L, 2000L);
    }

    @Test
    public void testReadCommitProcTime() throws Exception {
        this.setupProcessors(0, 0);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_read_commitproc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_read_commitproc_time_ms"), 0L, 1000L);
        Request req1 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req1);
        this.processRequestWithWait(this.createReadRequest(1L, 3));
        Thread.sleep(1000L);
        this.commitWithWait(req1);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)2L, (Object)values.get("cnt_read_commitproc_time_ms"));
        this.checkTimeMetric((Long)values.get("max_read_commitproc_time_ms"), 1000L, 2000L);
    }

    @Test
    public void testTimeWaitingEmptyPoolInCommitProcessorRead() throws Exception {
        this.setupProcessors(1, 1000);
        this.requestScheduled = new CountDownLatch(3);
        this.commitProcessor.processRequest(this.createReadRequest(0L, 2));
        this.commitProcessor.processRequest(this.createReadRequest(1L, 3));
        this.commitProcessor.processRequest(this.createReadRequest(2L, 4));
        this.requestScheduled.await(5L, TimeUnit.SECONDS);
        this.poolEmpytied = new CountDownLatch(1);
        this.commitProcessor.commit(this.createWriteRequest(1L, 1));
        this.poolEmpytied.await(5L, TimeUnit.SECONDS);
        long actual = (Long)MetricsUtils.currentServerMetrics().get("max_time_waiting_empty_pool_in_commit_processor_read_ms");
        this.checkTimeMetric(actual, 2500L, 3500L);
    }

    @Test
    public void testConcurrentRequestProcessingInCommitProcessor() throws Exception {
        this.setupProcessors(3, 1000);
        this.commitSeen = new CountDownLatch(1);
        this.requestScheduled = new CountDownLatch(3);
        this.commitProcessor.processRequest(this.createReadRequest(1L, 2));
        this.commitProcessor.processRequest(this.createReadRequest(1L, 3));
        this.commitProcessor.processRequest(this.createReadRequest(1L, 4));
        this.requestScheduled.await(5L, TimeUnit.SECONDS);
        this.poolEmpytied = new CountDownLatch(1);
        this.commitProcessor.commit(this.createWriteRequest(1L, 1));
        this.poolEmpytied.await(5L, TimeUnit.SECONDS);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)3L, (Object)values.get("max_concurrent_request_processing_in_commit_processor"));
    }

    @Test
    public void testReadsAfterWriteInSessionQueue() throws Exception {
        this.setupProcessors(0, 0);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        Request req1 = this.createWriteRequest(1L, 1);
        this.processRequestWithWait(req1);
        this.processRequestWithWait(this.createReadRequest(1L, 2));
        this.processRequestWithWait(this.createReadRequest(1L, 3));
        this.processRequestWithWait(this.createReadRequest(1L, 4));
        this.commitWithWait(req1);
        this.checkMetrics("reads_after_write_in_session_queue", 3L, 3L, 3.0, 1L, 3L);
    }

    @Test
    public void testReadsQueuedInCommitProcessor() throws Exception {
        this.setupProcessors(0, 0);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        this.processRequestWithWait(this.createReadRequest(1L, 2));
        this.checkMetrics("read_commit_proc_req_queued", 1L, 1L, 1.0, 2L, 2L);
    }

    @Test
    public void testWritesQueuedInCommitProcessor() throws Exception {
        this.setupProcessors(0, 0);
        Request req1 = this.createWriteRequest(1L, 1);
        this.processRequestWithWait(req1);
        Request req2 = this.createWriteRequest(1L, 2);
        this.processRequestWithWait(req2);
        this.checkMetrics("write_commit_proc_req_queued", 1L, 2L, 1.5, 2L, 3L);
        this.commitWithWait(req1);
        this.checkMetrics("write_commit_proc_req_queued", 1L, 2L, 1.6667, 3L, 5L);
        this.commitWithWait(req2);
        this.checkMetrics("write_commit_proc_req_queued", 1L, 2L, 1.5, 4L, 6L);
        this.processRequestWithWait(this.createReadRequest(1L, 1));
        this.checkMetrics("write_commit_proc_req_queued", 0L, 2L, 1.2, 5L, 6L);
    }

    @Test
    public void testCommitsQueuedInCommitProcessor() throws Exception {
        this.setupProcessors(0, 0);
        this.commitWithWait(this.createWriteRequest(1L, 1));
        this.commitWithWait(this.createWriteRequest(1L, 2));
        this.checkMetrics("commit_commit_proc_req_queued", 1L, 1L, 1.0, 2L, 2L);
    }

    @Test
    public void testCommitsQueued() throws Exception {
        this.setupProcessors(0, 0);
        this.commitWithWait(this.createWriteRequest(1L, 1));
        this.commitWithWait(this.createWriteRequest(1L, 2));
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((long)2L, (long)((Long)values.get("request_commit_queued")));
    }

    @Test
    public void testPendingSessionQueueSize() throws Exception {
        this.setupProcessors(0, 0);
        Request req1 = this.createWriteRequest(1L, 1);
        this.processRequestWithWait(req1);
        Request req2 = this.createWriteRequest(2L, 2);
        this.processRequestWithWait(req2);
        Request req3 = this.createWriteRequest(2L, 3);
        this.processRequestWithWait(req3);
        this.commitWithWait(req1);
        this.checkMetrics("pending_session_queue_size", 2L, 2L, 2.0, 1L, 2L);
        this.commitWithWait(req2);
        this.checkMetrics("pending_session_queue_size", 1L, 2L, 1.5, 2L, 3L);
        this.commitWithWait(req3);
        this.checkMetrics("pending_session_queue_size", 1L, 2L, 1.333, 3L, 4L);
    }

    private class DummyFinalProcessor
    implements RequestProcessor {
        int processTime;

        public DummyFinalProcessor(int processTime) {
            this.processTime = processTime;
        }

        public void processRequest(Request request) {
            if (this.processTime > 0) {
                try {
                    if (CommitProcessorMetricsTest.this.commitSeen != null) {
                        CommitProcessorMetricsTest.this.commitSeen.await(5L, TimeUnit.SECONDS);
                    }
                    Thread.sleep(this.processTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void shutdown() {
        }
    }

    private class TestWorkerService
    extends WorkerService {
        public TestWorkerService(int numWorkerThreads) {
            super("CommitProcWork", numWorkerThreads, true);
        }

        public void schedule(WorkerService.WorkRequest workRequest, long id) {
            super.schedule(workRequest, id);
            if (CommitProcessorMetricsTest.this.requestScheduled != null) {
                CommitProcessorMetricsTest.this.requestScheduled.countDown();
            }
        }
    }

    private class TestCommitProcessor
    extends CommitProcessor {
        int numWorkerThreads;

        public TestCommitProcessor(RequestProcessor finalProcessor, int numWorkerThreads) {
            super(finalProcessor, "1", true, null);
            this.numWorkerThreads = numWorkerThreads;
        }

        public void start() {
            this.workerPool = new TestWorkerService(this.numWorkerThreads);
            super.start();
            Thread.State state = super.getState();
            while (state != Thread.State.WAITING) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                state = super.getState();
            }
            LOG.info("numWorkerThreads in Test is {}", (Object)this.numWorkerThreads);
        }

        protected void endOfIteration() {
            if (CommitProcessorMetricsTest.this.requestProcessed != null) {
                CommitProcessorMetricsTest.this.requestProcessed.countDown();
            }
        }

        protected void waitForEmptyPool() throws InterruptedException {
            if (CommitProcessorMetricsTest.this.commitSeen != null) {
                CommitProcessorMetricsTest.this.commitSeen.countDown();
            }
            super.waitForEmptyPool();
            if (CommitProcessorMetricsTest.this.poolEmpytied != null) {
                CommitProcessorMetricsTest.this.poolEmpytied.countDown();
            }
        }
    }
}

