/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands;

import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.stream.cli.commands.AbstractStreamCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminCommand<ClientFlagsT extends CliFlags>
extends AbstractStreamCommand<ClientFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(AdminCommand.class);

    protected AdminCommand(CliSpec<ClientFlagsT> spec) {
        super(spec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean doApply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags bkFlags, ClientFlagsT cmdFlags) {
        StorageClientSettings settings = StorageClientSettings.newBuilder().clientName("bkctl").serviceUri(serviceURI.getUri().toString()).build();
        try (StorageAdminClient admin = StorageClientBuilder.newBuilder().withSettings(settings).buildAdmin();){
            this.run(admin, bkFlags, cmdFlags);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Failed to process stream admin command", (Throwable)e);
            this.spec.console().println("Failed to process stream admin command");
            e.printStackTrace(this.spec.console());
            return false;
        }
    }

    protected abstract void run(StorageAdminClient var1, BKFlags var2, ClientFlagsT var3) throws Exception;
}

