/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.bookkeeper.common.util.ExceptionMessageHelper;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;

class Buffer {
    public static final byte PADDING_BYTE = -16;
    public static final int ALIGNMENT = 4096;
    private static final int MAX_ALIGNMENT = 0x7FFFF000;
    static final byte[] PADDING = Buffer.generatePadding();
    final NativeIO nativeIO;
    final int bufferSize;
    ByteBuf buffer;
    ByteBuffer byteBuffer;
    ByteBufAllocator allocator;
    long pointer = 0L;

    Buffer(NativeIO nativeIO, ByteBufAllocator allocator, int bufferSize) throws IOException {
        Preconditions.checkArgument((boolean)Buffer.isAligned(bufferSize), (String)"Buffer size not aligned %d", (int)bufferSize);
        this.allocator = allocator;
        this.buffer = this.allocateAligned(4096, bufferSize);
        this.nativeIO = nativeIO;
        this.bufferSize = bufferSize;
        this.byteBuffer = this.buffer.nioBuffer(0, bufferSize);
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    private ByteBuf allocateAligned(int alignment, int bufferSize) {
        ByteBuf buf = this.allocator.directBuffer(bufferSize + alignment);
        long addr = buf.memoryAddress();
        if ((addr & (long)(alignment - 1)) == 0L) {
            this.pointer = addr;
            return buf.slice(0, bufferSize);
        }
        int alignOffset = (int)((long)alignment - (addr & (long)(alignment - 1)));
        this.pointer = addr + (long)alignOffset;
        return buf.slice(alignOffset, bufferSize);
    }

    boolean hasSpace(int size) throws IOException {
        if (size > this.bufferSize) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Write too large").kv("writeSize", (Object)size).kv("maxSize", (Object)this.bufferSize).toString());
        }
        return this.byteBuffer.remaining() >= size;
    }

    boolean hasData(int offset, int size) {
        return offset + size <= this.bufferSize;
    }

    void writeInt(int value) throws IOException {
        this.byteBuffer.putInt(value);
    }

    void writeByteBuf(ByteBuf bytebuf) throws IOException {
        int bytesWritten = bytebuf.readableBytes();
        ByteBuffer bytesToPut = bytebuf.nioBuffer();
        this.byteBuffer.put(bytesToPut);
        bytebuf.skipBytes(bytesWritten);
    }

    int readInt(int offset) throws IOException {
        if (!this.hasData(offset, 4)) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Buffer cannot satify int read").kv("offset", (Object)offset).kv("bufferSize", (Object)this.bufferSize).toString());
        }
        try {
            return this.byteBuffer.getInt(offset);
        }
        catch (Exception e) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Error reading int").kv("byteBuffer", (Object)this.byteBuffer.toString()).kv("offset", (Object)offset).kv("bufferSize", (Object)this.bufferSize).toString(), e);
        }
    }

    long readLong(int offset) throws IOException {
        if (!this.hasData(offset, 8)) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Buffer cannot satify long read").kv("offset", (Object)offset).kv("bufferSize", (Object)this.bufferSize).toString());
        }
        try {
            return this.byteBuffer.getLong(offset);
        }
        catch (Exception e) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Error reading long").kv("byteBuffer", (Object)this.byteBuffer.toString()).kv("offset", (Object)offset).kv("bufferSize", (Object)this.bufferSize).toString(), e);
        }
    }

    int readByteBuf(ByteBuf buffer, int offset, int size) throws IOException {
        int originalLimit = this.byteBuffer.limit();
        this.byteBuffer.position(offset);
        int bytesToRead = Math.min(size, this.byteBuffer.capacity() - offset);
        this.byteBuffer.limit(offset + bytesToRead);
        try {
            buffer.writeBytes(this.byteBuffer);
        }
        catch (Exception e) {
            throw new IOException(ExceptionMessageHelper.exMsg((String)"Error reading buffer").kv("byteBuffer", (Object)this.byteBuffer.toString()).kv("offset", (Object)offset).kv("size", (Object)size).kv("bufferSize", (Object)this.bufferSize).toString(), e);
        }
        finally {
            this.byteBuffer.limit(originalLimit);
        }
        return bytesToRead;
    }

    long pointer() {
        return this.pointer;
    }

    long pointer(long offset, long expectedWrite) {
        if (offset == 0L) {
            return this.pointer;
        }
        if (offset + expectedWrite > (long)this.byteBuffer.capacity()) {
            throw new IllegalArgumentException(ExceptionMessageHelper.exMsg((String)"Buffer overflow").kv("offset", (Object)offset).kv("expectedWrite", (Object)expectedWrite).kv("capacity", (Object)this.byteBuffer.capacity()).toString());
        }
        return this.pointer + offset;
    }

    int position() {
        return this.byteBuffer.position();
    }

    int size() {
        return this.bufferSize;
    }

    int padToAlignment() {
        int bufferPos = this.byteBuffer.position();
        int nextAlignment = Buffer.nextAlignment(bufferPos);
        this.byteBuffer.put(PADDING, 0, nextAlignment - bufferPos);
        return nextAlignment;
    }

    void reset() {
        this.byteBuffer.clear();
    }

    void free() {
        ReferenceCountUtil.release((Object)this.buffer);
        this.buffer = null;
        this.byteBuffer = null;
    }

    private static byte[] generatePadding() {
        byte[] padding = new byte[4096];
        Arrays.fill(padding, (byte)-16);
        return padding;
    }

    static boolean isAligned(long size) {
        return size >= 0L && (0xFFFL & size) == 0L;
    }

    static int nextAlignment(int pos) {
        Preconditions.checkArgument((pos <= 0x7FFFF000 ? 1 : 0) != 0, (String)"position (0x%x) must be lower or equal to max alignment (0x%x)", (int)pos, (int)0x7FFFF000);
        Preconditions.checkArgument((pos >= 0 ? 1 : 0) != 0, (String)"position (0x%x) must be positive", (int)pos);
        return pos + 4095 & 0xFFFFF000;
    }
}

