/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import javax.security.auth.login.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.SaslTestUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SaslAuthRequiredMultiClientTest
extends ClientBase {
    @BeforeAll
    public static void setUpBeforeClass() {
        System.setProperty(SaslTestUtil.requireSASLAuthProperty, "true");
        System.setProperty(SaslTestUtil.authProviderProperty, SaslTestUtil.authProvider);
        System.setProperty(SaslTestUtil.jaasConfig, SaslTestUtil.createJAASConfigFile("jaas.conf", "test"));
    }

    @AfterAll
    public static void tearDownAfterClass() {
        System.clearProperty(SaslTestUtil.requireSASLAuthProperty);
        System.clearProperty(SaslTestUtil.authProviderProperty);
        System.clearProperty(SaslTestUtil.jaasConfig);
    }

    @Test
    public void testClientOpWithInvalidSASLUserAuthAfterSuccessLogin() throws Exception {
        SaslAuthRequiredMultiClientTest.resetJaasConfiguration("jaas.conf", "super", "test");
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/foobar", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            Assertions.fail((String)"Client operation should succeed with valid SASL configuration.");
        }
        SaslAuthRequiredMultiClientTest.resetJaasConfiguration("jaas.conf", "super_wrong", "test");
        try (TestableZooKeeper wrongUserZk = this.createClient();){
            wrongUserZk.create("/bar", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assertions.fail((String)"Client with wrong SASL config should not pass SASL authentication.");
        }
        catch (KeeperException e) {
            Assertions.assertEquals((Object)KeeperException.Code.AUTHFAILED, (Object)e.code());
        }
    }

    @Test
    public void testClientOpWithInvalidSASLPasswordAuthAfterSuccessLogin() throws Exception {
        SaslAuthRequiredMultiClientTest.resetJaasConfiguration("jaas.conf", "super", "test");
        try (TestableZooKeeper zk = this.createClient();){
            zk.create("/foobar", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            Assertions.fail((String)"Client operation should succeed with valid SASL configuration.");
        }
        SaslAuthRequiredMultiClientTest.resetJaasConfiguration("jaas.conf", "super", "test_wrongong");
        try (TestableZooKeeper wrongPasswordZk = this.createClient();){
            wrongPasswordZk.create("/bar", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
            Assertions.fail((String)"Client with wrong SASL config should not pass SASL authentication.");
        }
        catch (KeeperException e) {
            Assertions.assertEquals((Object)KeeperException.Code.AUTHFAILED, (Object)e.code());
        }
    }

    protected static void resetJaasConfiguration(String fileName, String userName, String password) {
        Configuration.setConfiguration(null);
        System.setProperty(SaslTestUtil.jaasConfig, SaslTestUtil.createJAASConfigFile(fileName, userName, password));
    }
}

