/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.Arrays;
import java.util.Collections;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilTest
extends ZKTestCase {
    @Test
    public void testStringSplit() {
        String s1 = "   a  ,   b  , ";
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)StringUtils.split((String)"   a  ,   b  , ", (String)","));
        Assertions.assertEquals(Collections.emptyList(), (Object)StringUtils.split((String)"", (String)","));
        String s3 = "1, , 2";
        Assertions.assertEquals(Arrays.asList("1", "2"), (Object)StringUtils.split((String)"1, , 2", (String)","));
        String s4 = "1, \t , 2";
        Assertions.assertEquals(Arrays.asList("1", "2"), (Object)StringUtils.split((String)"1, \t , 2", (String)","));
    }

    @Test
    public void testStringJoinNullDelim() {
        Assertions.assertThrows(NullPointerException.class, () -> StringUtils.joinStrings(Collections.emptyList(), null));
    }

    @Test
    public void testStringJoinNullListNullDelim() {
        Assertions.assertThrows(NullPointerException.class, () -> StringUtils.joinStrings(null, null));
    }

    @Test
    public void testStringJoinNullList() {
        Assertions.assertNull((Object)StringUtils.joinStrings(null, (String)","));
    }

    @Test
    public void testStringJoin() {
        String expected = "a,B,null,d";
        Assertions.assertEquals((Object)"a,B,null,d", (Object)StringUtils.joinStrings(Arrays.asList("a", "B", null, "d"), (String)","));
    }
}

