/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.cassandra.net.ConnectionCategory;

public enum ConnectionType {
    LEGACY_MESSAGES(0),
    URGENT_MESSAGES(1),
    SMALL_MESSAGES(2),
    LARGE_MESSAGES(3),
    STREAMING(4);

    public static final List<ConnectionType> MESSAGING_TYPES;
    public final int id;
    private static final ConnectionType[] values;

    private ConnectionType(int id) {
        this.id = id;
    }

    public int twoBitID() {
        if (this.id < 0 || this.id > 3) {
            throw new AssertionError();
        }
        return this.id;
    }

    public boolean isStreaming() {
        return this == STREAMING;
    }

    public boolean isMessaging() {
        return !this.isStreaming();
    }

    public ConnectionCategory category() {
        return this == STREAMING ? ConnectionCategory.STREAMING : ConnectionCategory.MESSAGING;
    }

    public static ConnectionType fromId(int id) {
        return values[id];
    }

    static {
        MESSAGING_TYPES = ImmutableList.of((Object)((Object)URGENT_MESSAGES), (Object)((Object)SMALL_MESSAGES), (Object)((Object)LARGE_MESSAGES));
        values = ConnectionType.values();
    }
}

