/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.InflaterInputStream;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceCodec;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;

class StackTraceReaderV2
implements StackTraceReader {
    private DataInputStream dis;
    private List<String> stringDic = new ArrayList<String>();
    private List<StackFrame> frameDic = new ArrayList<StackFrame>();
    private Map<StackFrame, StackTraceElement> frameCache = new HashMap<StackFrame, StackTraceElement>();
    private List<String> dynStringDic = new ArrayList<String>();
    private boolean loaded;
    private long threadId;
    private String threadName;
    private long timestamp;
    private Thread.State threadState;
    private String[] counterNames = new String[0];
    private long[] counterValues = new long[0];
    private CounterArray counters = new CounterArray(this.counterNames, this.counterValues);
    private StackFrameList trace;

    public StackTraceReaderV2(InputStream is) {
        this.dis = new DataInputStream(new BufferedInputStream(new InflaterInputStream(is), 65536));
        this.stringDic.add(null);
        this.dynStringDic.add(null);
        this.frameDic.add(null);
        this.loaded = false;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public long getThreadId() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.threadId;
    }

    @Override
    public long getTimestamp() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.timestamp;
    }

    @Override
    public StackTraceElement[] getTrace() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        StackTraceElement[] strace = new StackTraceElement[this.trace.depth()];
        for (int i = 0; i != strace.length; ++i) {
            StackFrame frame = this.trace.frameAt(i);
            StackTraceElement e = this.frameCache.get(frame);
            if (e == null) {
                e = frame.toStackTraceElement();
                this.frameCache.put(frame, e);
            }
            strace[i] = e;
        }
        return strace;
    }

    @Override
    public StackFrameList getStackTrace() {
        if (!this.isLoaded()) {
            throw new NoSuchElementException();
        }
        return this.trace;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Thread.State getThreadState() {
        return this.threadState;
    }

    @Override
    public CounterCollection getCounters() {
        return this.counters;
    }

    @Override
    public boolean loadNext() throws IOException {
        block7: {
            this.loaded = false;
            while (true) {
                int tag;
                if ((tag = this.dis.read()) < 0) {
                    this.dis.close();
                    break block7;
                }
                if (tag == 1) {
                    String str = this.dis.readUTF();
                    this.stringDic.add(str);
                    continue;
                }
                if (tag == 2) {
                    StackFrame ste = this.readStackTraceElement();
                    this.frameDic.add(ste);
                    continue;
                }
                if (tag == 3) {
                    this.readTraceInfo();
                    this.loaded = true;
                    break block7;
                }
                if (tag == 4) {
                    int id = StackTraceCodec.readVarInt(this.dis);
                    String str = this.dis.readUTF();
                    while (this.dynStringDic.size() <= id) {
                        this.dynStringDic.add(null);
                    }
                    this.dynStringDic.set(id, str);
                    continue;
                }
                if (tag != 5) break;
                String str = this.dis.readUTF();
                int n = this.counterNames.length;
                this.counterNames = Arrays.copyOf(this.counterNames, n + 1);
                this.counterValues = Arrays.copyOf(this.counterValues, n + 1);
                this.counterNames[n] = str;
                this.counters = new CounterArray(this.counterNames, this.counterValues);
            }
            throw new IOException("Data format error");
        }
        return this.loaded;
    }

    protected void readTraceInfo() throws IOException {
        this.threadId = StackTraceCodec.readVarLong(this.dis);
        this.threadName = this.dynStringDic.get(StackTraceCodec.readVarInt(this.dis));
        this.timestamp = StackTraceCodec.readTimestamp(this.dis);
        this.threadState = this.readState();
        this.readCounters();
        this.readStackTrace();
    }

    protected Thread.State readState() throws IOException {
        int n = StackTraceCodec.readVarInt(this.dis);
        return n == 0 ? null : Thread.State.values()[n - 1];
    }

    protected void readCounters() throws IOException {
        Arrays.fill(this.counterValues, Long.MIN_VALUE);
        boolean[] mask = new boolean[this.counterNames.length];
        for (int n = 0; n < mask.length; n += 8) {
            byte b = this.dis.readByte();
            for (int i = 0; i != 8; ++i) {
                if (n + i >= mask.length) continue;
                mask[n + i] = (b & 1 << i) != 0;
            }
        }
        for (int i = 0; i != mask.length; ++i) {
            if (!mask[i]) continue;
            this.counterValues[i] = StackTraceCodec.readVarLong(this.dis);
        }
    }

    protected void readStackTrace() throws IOException {
        int len = StackTraceCodec.readVarInt(this.dis);
        StackFrame[] frames = new StackFrame[len];
        for (int i = 0; i != len; ++i) {
            int ref = StackTraceCodec.readVarInt(this.dis);
            frames[i] = this.frameDic.get(ref);
        }
        this.trace = new StackFrameArray(frames);
    }

    private StackFrame readStackTraceElement() throws IOException {
        int npkg = StackTraceCodec.readVarInt(this.dis);
        int ncn = StackTraceCodec.readVarInt(this.dis);
        int nmtd = StackTraceCodec.readVarInt(this.dis);
        int nfile = StackTraceCodec.readVarInt(this.dis);
        int line = StackTraceCodec.readVarInt(this.dis) - 2;
        String cp = this.stringDic.get(npkg);
        String cn = this.stringDic.get(ncn);
        String mtd = this.stringDic.get(nmtd);
        String file = this.stringDic.get(nfile);
        StackFrame e = new StackFrame(cp, cn, mtd, file, line);
        return e;
    }
}

