/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.util.json;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.gridkit.jvmtool.jackson.DefaultPrettyPrinter;
import org.gridkit.jvmtool.jackson.JsonGenerationException;
import org.gridkit.jvmtool.jackson.JsonGenerator;
import org.gridkit.jvmtool.jackson.JsonMiniFactory;
import org.gridkit.jvmtool.jackson.PrettyPrinter;
import org.gridkit.jvmtool.util.json.JsonStreamWriter;

public class SmartJsonWriter
implements JsonStreamWriter {
    final JsonGenerator gen;
    protected Writer writer;
    String lastField = "/";
    List<String> stack = new ArrayList<String>();
    int skipContent = 0;
    boolean skipValue;

    public SmartJsonWriter(Writer writer) {
        this.writer = writer;
        this.gen = JsonMiniFactory.createJsonGenerator(writer);
        this.gen.setPrettyPrinter(new DefaultPrettyPrinter());
    }

    public void setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this.gen.setPrettyPrinter(prettyPrinter);
    }

    public void flush() {
        try {
            this.gen.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void push(String frame) {
        this.stack.add(frame);
        if (this.skipValue) {
            ++this.skipContent;
        }
    }

    private void pop() {
        String frame = this.stack.remove(this.stack.size() - 1);
        if ("[]".equals(frame)) {
            this.lastField = frame;
        }
        if (this.skipContent > 0) {
            --this.skipContent;
        }
        if (this.skipContent == 0) {
            this.skipValue = false;
        }
    }

    private void endValue() {
        if (this.skipContent == 0) {
            this.skipValue = false;
        }
    }

    protected void skipNextValue() {
        this.skipValue = true;
    }

    protected boolean lastFrameIs(String frame) {
        return frame.equals(this.stack.get(this.stack.size() - 1));
    }

    protected boolean lastFramesAre(String ... frames) {
        if (this.stack.size() >= frames.length) {
            for (int i = 0; i != frames.length; ++i) {
                if (this.stack.get(this.stack.size() - frames.length + i).equals(frames[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected int getStackDepth() {
        return this.stack.size();
    }

    protected boolean checkFieldWritable(String field) {
        return true;
    }

    @Override
    public void writeStartArray() throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeStartArray();
        }
        this.push(this.lastField);
        this.lastField = "[]";
    }

    @Override
    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeEndArray();
        }
        this.pop();
    }

    @Override
    public void writeStartObject() throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeStartObject();
        }
        this.push(this.lastField);
        this.lastField = null;
    }

    @Override
    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeEndObject();
        }
        this.pop();
    }

    @Override
    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            if (this.checkFieldWritable(name)) {
                this.gen.writeFieldName(name);
            } else {
                this.skipValue = true;
            }
        }
        this.lastField = name;
    }

    @Override
    public void writeString(String text) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeString(text);
        }
        this.endValue();
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeString(text, offset, len);
        }
        this.endValue();
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.gen.writeRawUTF8String(text, offset, length);
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.gen.writeUTF8String(text, offset, length);
    }

    @Override
    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this.gen.writeRaw(text);
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.gen.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.gen.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.gen.writeRaw(c);
    }

    @Override
    public void writeRawValue(String text) throws IOException, JsonGenerationException {
        this.gen.writeRawValue(text);
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.gen.writeRawValue(text, offset, len);
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.gen.writeRawValue(text, offset, len);
    }

    @Override
    public void writeNumber(int v) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(v);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(long v) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(v);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(v);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(double d) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(d);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(float f) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(f);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNumber(dec);
        }
        this.endValue();
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        if (!this.skipValue) {
            this.gen.writeNumber(encodedValue);
        }
        this.endValue();
    }

    @Override
    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeBoolean(state);
        }
        this.endValue();
    }

    @Override
    public void writeNull() throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            this.gen.writeNull();
        }
        this.endValue();
    }

    @Override
    public void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeStringField(fieldName, value);
        }
    }

    @Override
    public final void writeBooleanField(String fieldName, boolean value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeBooleanField(fieldName, value);
        }
    }

    @Override
    public final void writeNullField(String fieldName) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNullField(fieldName);
        }
    }

    @Override
    public final void writeNumberField(String fieldName, int value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNumberField(fieldName, value);
        }
    }

    @Override
    public final void writeNumberField(String fieldName, long value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNumberField(fieldName, value);
        }
    }

    @Override
    public final void writeNumberField(String fieldName, double value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNumberField(fieldName, value);
        }
    }

    @Override
    public final void writeNumberField(String fieldName, float value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNumberField(fieldName, value);
        }
    }

    @Override
    public final void writeNumberField(String fieldName, BigDecimal value) throws IOException, JsonGenerationException {
        if (!this.skipValue && this.checkFieldWritable(fieldName)) {
            this.gen.writeNumberField(fieldName, value);
        }
    }

    @Override
    public final void writeArrayFieldStart(String fieldName) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            if (this.checkFieldWritable(fieldName)) {
                this.gen.writeArrayFieldStart(fieldName);
            } else {
                this.skipValue = true;
            }
        }
        this.push(fieldName);
        this.lastField = "[]";
    }

    @Override
    public final void writeObjectFieldStart(String fieldName) throws IOException, JsonGenerationException {
        if (!this.skipValue) {
            if (this.checkFieldWritable(fieldName)) {
                this.gen.writeObjectFieldStart(fieldName);
            } else {
                this.skipValue = true;
            }
        }
        this.push(fieldName);
    }
}

