/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.github.jamm.MemoryMeterListener;

final class TreePrinter
implements MemoryMeterListener {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    private final Map<Object, ObjectInfo> mapping = new IdentityHashMap<Object, ObjectInfo>();
    private final int maxDepth;
    private boolean hasMissingElements;
    private Object root;

    public TreePrinter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public void started(Object obj) {
        this.root = obj;
        this.mapping.put(obj, ObjectInfo.newRoot(obj.getClass()));
    }

    @Override
    public void fieldAdded(Object obj, String fieldName, Object fieldValue) {
        ObjectInfo parent = this.mapping.get(obj);
        if (parent != null && parent.depth <= this.maxDepth - 1) {
            ObjectInfo field = parent.addChild(fieldName, fieldValue.getClass());
            this.mapping.put(fieldValue, field);
        } else {
            this.hasMissingElements = true;
        }
    }

    @Override
    public void objectMeasured(Object current, long size) {
        ObjectInfo field = this.mapping.get(current);
        if (field != null) {
            field.size = size;
        }
    }

    @Override
    public void objectCounted(Object current) {
    }

    @Override
    public void done(long size) {
        System.out.println(this.mapping.get(this.root).toString(!this.hasMissingElements));
    }

    public static class Factory
    implements MemoryMeterListener.Factory {
        private final int depth;

        public Factory(int depth) {
            this.depth = depth;
        }

        @Override
        public MemoryMeterListener newInstance() {
            return new TreePrinter(this.depth);
        }
    }

    private static final class ObjectInfo {
        private static final String ROOT_NAME = "root";
        private final String name;
        private final String className;
        private final int depth;
        private List<ObjectInfo> children = Collections.emptyList();
        private long size;
        private long totalSize = -1L;

        public ObjectInfo(String name, Class<?> clazz, int depth) {
            this.name = name;
            this.className = ObjectInfo.className(clazz);
            this.depth = depth;
        }

        public static ObjectInfo newRoot(Class<?> clazz) {
            return new ObjectInfo(ROOT_NAME, clazz, 0);
        }

        public ObjectInfo addChild(String childName, Class<?> childClass) {
            ObjectInfo child = new ObjectInfo(childName, childClass, this.depth + 1);
            if (this.children.isEmpty()) {
                this.children = new ArrayList<ObjectInfo>();
            }
            this.children.add(child);
            return child;
        }

        public long totalSize() {
            if (this.totalSize < 0L) {
                this.totalSize = this.computeTotalSize();
            }
            return this.totalSize;
        }

        private long computeTotalSize() {
            long total = this.size;
            for (ObjectInfo child : this.children) {
                total += child.totalSize();
            }
            return total;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean printTotalSize) {
            return this.append("", true, printTotalSize, new StringBuilder().append(LINE_SEPARATOR).append(LINE_SEPARATOR)).toString();
        }

        private StringBuilder append(String indentation, boolean isLast, boolean printTotalSize, StringBuilder builder) {
            if (!this.name.equals(ROOT_NAME)) {
                builder.append(indentation).append('|').append(LINE_SEPARATOR).append(indentation).append("+--");
            }
            builder.append(this.name).append(" [").append(this.className).append("] ");
            if (this.size != 0L) {
                if (printTotalSize) {
                    ObjectInfo.appendSizeTo(builder, this.totalSize());
                    builder.append(' ');
                }
                builder.append('(');
                ObjectInfo.appendSizeTo(builder, this.size);
                builder.append(')');
            }
            return this.appendChildren(ObjectInfo.childIntentation(indentation, isLast), printTotalSize, builder.append(LINE_SEPARATOR));
        }

        private StringBuilder appendChildren(String indentation, boolean printTotalSize, StringBuilder builder) {
            int m = this.children.size();
            for (int i = 0; i < m; ++i) {
                ObjectInfo child = this.children.get(i);
                boolean isLast = i == m - 1;
                child.append(indentation, isLast, printTotalSize, builder);
            }
            return builder;
        }

        private static String childIntentation(String indentation, boolean isLast) {
            return isLast ? indentation + "  " : indentation + "|  ";
        }

        private static String className(Class<? extends Object> clazz) {
            if (clazz.isArray()) {
                return clazz.getComponentType().getName() + "[]";
            }
            return clazz.getName();
        }

        private static void appendSizeTo(StringBuilder builder, long size) {
            if (size >= 0x100000L) {
                builder.append(String.format("%.2f", (double)size / 1048576.0)).append(" KB");
            } else if (size >= 1024L) {
                builder.append(String.format("%.2f", (double)size / 1024.0)).append(" KB");
            } else {
                builder.append(size).append(" bytes");
            }
        }
    }
}

