/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import net.openhft.chronicle.core.Jvm;

public enum PrecreatedFiles {

    private static final String PRE_CREATED_FILE_SUFFIX = ".precreated";

    public static void renamePreCreatedFileToRequiredFile(File requiredQueueFile) {
        File preCreatedFile = PrecreatedFiles.preCreatedFile(requiredQueueFile);
        if (preCreatedFile.exists() && !preCreatedFile.renameTo(requiredQueueFile)) {
            Jvm.warn().on(PrecreatedFiles.class, "Failed to rename pre-created queue file");
        }
    }

    public static File preCreatedFileForStoreFile(File requiredStoreFile) {
        return new File(requiredStoreFile.getParentFile(), requiredStoreFile.getName() + PRE_CREATED_FILE_SUFFIX);
    }

    public static File preCreatedFile(File requiredQueueFile) {
        String fileName = requiredQueueFile.getName();
        String name = fileName.substring(0, fileName.length() - 4);
        return new File(requiredQueueFile.getParentFile(), name + PRE_CREATED_FILE_SUFFIX);
    }
}

