/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.datastax.shaded.netty.channel.socket.SocketChannel;
import com.google.common.net.HostAndPort;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.stress.settings.StressSettings;

public class JavaDriverClient {
    public final List<String> hosts;
    public final int port;
    public final String username;
    public final String password;
    public final AuthProvider authProvider;
    public final int maxPendingPerConnection;
    public final int connectionsPerHost;
    private final ProtocolVersion protocolVersion;
    private final EncryptionOptions encryptionOptions;
    private Cluster cluster;
    private Session session;
    private final LoadBalancingPolicy loadBalancingPolicy;
    private static final ConcurrentMap<String, PreparedStatement> stmts;

    public JavaDriverClient(StressSettings settings, String host, int port) {
        this(settings, Collections.singletonList(host), port, new EncryptionOptions());
    }

    public JavaDriverClient(StressSettings settings, List<String> hosts, int port) {
        this(settings, hosts, port, new EncryptionOptions());
    }

    public JavaDriverClient(StressSettings settings, List<String> hosts, int port, EncryptionOptions encryptionOptions) {
        this.protocolVersion = settings.mode.protocolVersion;
        this.hosts = hosts;
        this.port = port;
        this.username = settings.mode.username;
        this.password = settings.mode.password;
        this.authProvider = settings.mode.authProvider;
        this.encryptionOptions = new EncryptionOptions(encryptionOptions).applyConfig();
        this.loadBalancingPolicy = this.loadBalancingPolicy(settings);
        this.connectionsPerHost = settings.mode.connectionsPerHost == null ? 8 : settings.mode.connectionsPerHost;
        int maxThreadCount = 0;
        maxThreadCount = settings.rate.auto ? settings.rate.maxThreads : settings.rate.threadCount;
        int requestsPerConnection = maxThreadCount / this.connectionsPerHost + this.connectionsPerHost;
        this.maxPendingPerConnection = settings.mode.maxPendingPerConnection == null ? Math.max(128, requestsPerConnection) : settings.mode.maxPendingPerConnection;
    }

    private LoadBalancingPolicy loadBalancingPolicy(StressSettings settings) {
        DCAwareRoundRobinPolicy.Builder policyBuilder = DCAwareRoundRobinPolicy.builder();
        if (settings.node.datacenter != null) {
            policyBuilder.withLocalDc(settings.node.datacenter);
        }
        DCAwareRoundRobinPolicy ret = null;
        if (settings.node.datacenter != null) {
            ret = policyBuilder.build();
        }
        if (settings.node.isWhiteList) {
            ret = new WhiteListPolicy((LoadBalancingPolicy)(ret == null ? policyBuilder.build() : ret), settings.node.resolveAll(settings.port.nativePort));
        }
        return new TokenAwarePolicy((LoadBalancingPolicy)(ret == null ? policyBuilder.build() : ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepare(String query) {
        PreparedStatement stmt = (PreparedStatement)stmts.get(query);
        if (stmt != null) {
            return stmt;
        }
        ConcurrentMap<String, PreparedStatement> concurrentMap = stmts;
        synchronized (concurrentMap) {
            stmt = (PreparedStatement)stmts.get(query);
            if (stmt != null) {
                return stmt;
            }
            stmt = this.getSession().prepare(query);
            stmts.put(query, stmt);
        }
        return stmt;
    }

    public void connect(ProtocolOptions.Compression compression) throws Exception {
        PoolingOptions poolingOpts = new PoolingOptions().setConnectionsPerHost(HostDistance.LOCAL, this.connectionsPerHost, this.connectionsPerHost).setMaxRequestsPerConnection(HostDistance.LOCAL, this.maxPendingPerConnection).setNewConnectionThreshold(HostDistance.LOCAL, 100);
        ArrayList<InetSocketAddress> contacts = new ArrayList<InetSocketAddress>();
        for (String host : this.hosts) {
            HostAndPort hap = HostAndPort.fromString((String)host).withDefaultPort(this.port);
            InetSocketAddress contact = new InetSocketAddress(InetAddress.getByName(hap.getHost()), hap.getPort());
            contacts.add(contact);
        }
        Cluster.Builder clusterBuilder = Cluster.builder().addContactPointsWithPorts(contacts).withPoolingOptions(poolingOpts).withoutJMXReporting().withProtocolVersion(this.protocolVersion).withoutMetrics();
        if (this.loadBalancingPolicy != null) {
            clusterBuilder.withLoadBalancingPolicy(this.loadBalancingPolicy);
        }
        clusterBuilder.withCompression(compression);
        if (this.encryptionOptions.getEnabled().booleanValue()) {
            SSLContext sslContext = SSLFactory.createSSLContext((EncryptionOptions)this.encryptionOptions, (boolean)true);
            RemoteEndpointAwareJdkSSLOptions sslOptions = new RemoteEndpointAwareJdkSSLOptions(sslContext, this.encryptionOptions.cipherSuitesArray()){

                protected SSLEngine newSSLEngine(SocketChannel channel, InetSocketAddress remoteEndpoint) {
                    SSLEngine engine = super.newSSLEngine(channel, remoteEndpoint);
                    String[] acceptedProtocols = JavaDriverClient.this.encryptionOptions.acceptedProtocolsArray();
                    if (acceptedProtocols != null && acceptedProtocols.length > 0) {
                        engine.setEnabledProtocols(acceptedProtocols);
                    }
                    return engine;
                }
            };
            clusterBuilder.withSSL((SSLOptions)sslOptions);
        }
        if (this.authProvider != null) {
            clusterBuilder.withAuthProvider(this.authProvider);
        } else if (this.username != null) {
            clusterBuilder.withCredentials(this.username, this.password);
        }
        this.cluster = clusterBuilder.build();
        Metadata metadata = this.cluster.getMetadata();
        System.out.printf("Connected to cluster: %s, max pending requests per connection %d, max connections per host %d%n", metadata.getClusterName(), this.maxPendingPerConnection, this.connectionsPerHost);
        for (Host host : metadata.getAllHosts()) {
            System.out.printf("Datacenter: %s; Host: %s; Rack: %s%n", host.getDatacenter(), host.getAddress() + ":" + host.getSocketAddress().getPort(), host.getRack());
        }
        this.session = this.cluster.connect();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public Session getSession() {
        return this.session;
    }

    public ResultSet execute(String query, org.apache.cassandra.db.ConsistencyLevel consistency) {
        SimpleStatement stmt = new SimpleStatement(query);
        if (consistency.isSerialConsistency()) {
            stmt.setSerialConsistencyLevel(JavaDriverClient.from(consistency));
        } else {
            stmt.setConsistencyLevel(JavaDriverClient.from(consistency));
        }
        return this.getSession().execute((Statement)stmt);
    }

    public ResultSet executePrepared(PreparedStatement stmt, List<Object> queryParams, org.apache.cassandra.db.ConsistencyLevel consistency) {
        if (consistency.isSerialConsistency()) {
            stmt.setSerialConsistencyLevel(JavaDriverClient.from(consistency));
        } else {
            stmt.setConsistencyLevel(JavaDriverClient.from(consistency));
        }
        BoundStatement bstmt = stmt.bind(queryParams.toArray(new Object[queryParams.size()]));
        return this.getSession().execute((Statement)bstmt);
    }

    public static ConsistencyLevel from(org.apache.cassandra.db.ConsistencyLevel cl) {
        switch (cl) {
            case ANY: {
                return ConsistencyLevel.ANY;
            }
            case ONE: {
                return ConsistencyLevel.ONE;
            }
            case TWO: {
                return ConsistencyLevel.TWO;
            }
            case THREE: {
                return ConsistencyLevel.THREE;
            }
            case QUORUM: {
                return ConsistencyLevel.QUORUM;
            }
            case ALL: {
                return ConsistencyLevel.ALL;
            }
            case LOCAL_QUORUM: {
                return ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return ConsistencyLevel.EACH_QUORUM;
            }
            case LOCAL_ONE: {
                return ConsistencyLevel.LOCAL_ONE;
            }
            case SERIAL: {
                return ConsistencyLevel.SERIAL;
            }
            case LOCAL_SERIAL: {
                return ConsistencyLevel.LOCAL_SERIAL;
            }
        }
        throw new AssertionError();
    }

    public void disconnect() {
        this.cluster.close();
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
        stmts = new ConcurrentHashMap<String, PreparedStatement>();
    }
}

