/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym.word2vec;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.synonym.word2vec.TermAndBoost;
import org.apache.lucene.analysis.synonym.word2vec.Word2VecModel;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.NeighborQueue;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;

public class Word2VecSynonymProvider {
    private static final VectorSimilarityFunction SIMILARITY_FUNCTION = VectorSimilarityFunction.DOT_PRODUCT;
    private static final VectorEncoding VECTOR_ENCODING = VectorEncoding.FLOAT32;
    private final Word2VecModel word2VecModel;
    private final OnHeapHnswGraph hnswGraph;

    public Word2VecSynonymProvider(Word2VecModel model) throws IOException {
        this.word2VecModel = model;
        HnswGraphBuilder builder = HnswGraphBuilder.create((RandomAccessVectorValues)this.word2VecModel, (VectorEncoding)VECTOR_ENCODING, (VectorSimilarityFunction)SIMILARITY_FUNCTION, (int)16, (int)100, (long)HnswGraphBuilder.randSeed);
        this.hnswGraph = builder.build(this.word2VecModel.copy());
    }

    public List<TermAndBoost> getSynonyms(BytesRef term, int maxSynonymsPerTerm, float minAcceptedSimilarity) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        LinkedList<TermAndBoost> result = new LinkedList<TermAndBoost>();
        float[] query = this.word2VecModel.vectorValue(term);
        if (query != null) {
            NeighborQueue synonyms = HnswGraphSearcher.search((float[])query, (int)(maxSynonymsPerTerm + 1), (RandomAccessVectorValues)this.word2VecModel, (VectorEncoding)VECTOR_ENCODING, (VectorSimilarityFunction)SIMILARITY_FUNCTION, (OnHeapHnswGraph)this.hnswGraph, null, (int)Integer.MAX_VALUE);
            int size = synonyms.size();
            for (int i = 0; i < size; ++i) {
                float similarity = synonyms.topScore();
                int id = synonyms.pop();
                BytesRef synonym = this.word2VecModel.termValue(id);
                if (synonym.equals((Object)term) || !(similarity >= minAcceptedSimilarity)) continue;
                result.addFirst(new TermAndBoost(synonym, similarity));
            }
        }
        return result;
    }
}

