/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.FQLQueryIterator;
import org.apache.cassandra.fqltool.ResultHandler;
import org.apache.cassandra.fqltool.StoredResultSet;

@Command(name="compare", description="Compare result files generated by fqltool replay")
public class Compare
implements Runnable {
    @Arguments(usage="<path1> [<path2>...<pathN>]", description="Directories containing result files to compare.", required=true)
    private List<String> arguments = new ArrayList<String>();
    @Option(title="queries", name={"--queries"}, description="Directory to read the queries from. It is produced by the fqltool replay --store-queries option. ", required=true)
    private String querylog;

    @Override
    public void run() {
        Compare.compare(this.querylog, this.arguments);
    }

    public static void compare(String querylog, List<String> arguments) {
        List<ChronicleQueue> readQueues = null;
        try (ResultHandler rh = new ResultHandler(arguments, null, null);
             SingleChronicleQueue queryQ = SingleChronicleQueueBuilder.single((String)querylog).readOnly(true).build();
             FQLQueryIterator queries = new FQLQueryIterator(queryQ.createTailer(), 1);){
            readQueues = arguments.stream().map(s -> SingleChronicleQueueBuilder.single((String)s).readOnly(true).build()).collect(Collectors.toList());
            List<Iterator<ResultHandler.ComparableResultSet>> its = readQueues.stream().map(q -> new StoredResultSetIterator(q.createTailer())).collect(Collectors.toList());
            while (queries.hasNext()) {
                rh.handleResults((FQLQuery)queries.next(), Compare.resultSets(its));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (readQueues != null) {
                readQueues.forEach(Closeable::close);
            }
        }
    }

    @VisibleForTesting
    public static List<ResultHandler.ComparableResultSet> resultSets(List<Iterator<ResultHandler.ComparableResultSet>> its) {
        ArrayList<ResultHandler.ComparableResultSet> resultSets = new ArrayList<ResultHandler.ComparableResultSet>(its.size());
        for (Iterator<ResultHandler.ComparableResultSet> it : its) {
            if (it.hasNext()) {
                resultSets.add(it.next());
                continue;
            }
            resultSets.add(null);
        }
        return resultSets;
    }

    @VisibleForTesting
    public static class StoredResultSetIterator
    extends AbstractIterator<ResultHandler.ComparableResultSet> {
        private final ExcerptTailer tailer;

        public StoredResultSetIterator(ExcerptTailer tailer) {
            this.tailer = tailer;
        }

        protected ResultHandler.ComparableResultSet computeNext() {
            StoredResultSet srs = StoredResultSet.fromTailer(this.tailer);
            if (srs.hasMoreResultSets) {
                return srs;
            }
            return (ResultHandler.ComparableResultSet)this.endOfData();
        }
    }
}

