/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.db;

import com.datastax.driver.core.Row;
import java.util.Map;
import org.apache.cassandra.sidecar.db.DataObjectMappingException;
import org.jetbrains.annotations.NotNull;

public class ConnectedClientStats {
    public final String address;
    public final int port;
    public final String hostname;
    public final String username;
    public final String connectionStage;
    public final String protocolVersion;
    public final String driverName;
    public final String driverVersion;
    public final boolean sslEnabled;
    public final String sslProtocol;
    public final String sslCipherSuite;
    public final long requestCount;
    public final Map<String, String> clientOptions;
    public final String keyspaceName;
    public final String authenticationMode;
    public final Map<String, String> authenticationMetadata;

    public static ConnectedClientStats from(@NotNull Row row) throws DataObjectMappingException {
        return new ConnectedClientStats(row);
    }

    public ConnectedClientStats(@NotNull Row row) {
        this.address = row.getInet("address").getHostAddress();
        this.port = row.getInt("port");
        this.hostname = row.getString("hostname");
        this.username = row.getString("username");
        this.connectionStage = row.getString("connection_stage");
        this.protocolVersion = Integer.toString(row.getInt("protocol_version"));
        this.driverName = row.getString("driver_name");
        this.driverVersion = row.getString("driver_version");
        this.sslEnabled = row.getBool("ssl_enabled");
        this.sslProtocol = row.getString("ssl_protocol");
        this.sslCipherSuite = row.getString("ssl_cipher_suite");
        this.requestCount = row.getLong("request_count");
        this.keyspaceName = this.getStringFieldIfExists(row, "keyspace_name");
        this.authenticationMode = this.getStringFieldIfExists(row, "authentication_mode");
        this.authenticationMetadata = this.getMapFieldIfExists(row, "authentication_metadata");
        this.clientOptions = this.getMapFieldIfExists(row, "client_options");
    }

    public String getStringFieldIfExists(@NotNull Row row, String fieldName) {
        return row.getColumnDefinitions().contains(fieldName) ? row.getString(fieldName) : null;
    }

    public Map<String, String> getMapFieldIfExists(@NotNull Row row, String fieldName) {
        if (row.getColumnDefinitions().contains(fieldName)) {
            return row.getMap(fieldName, String.class, String.class);
        }
        return null;
    }
}

