/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.retry;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.CompletableFuture;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.retry.RetryAction;
import org.apache.cassandra.sidecar.client.retry.RetryPolicy;
import org.apache.cassandra.sidecar.common.request.Request;

public class LiveMigrationDownloadRetryPolicy
extends RetryPolicy {
    private final RetryPolicy delegate;
    private final String destinationPath;

    public LiveMigrationDownloadRetryPolicy(RetryPolicy delegate, String destinationPath) {
        this.delegate = delegate;
        this.destinationPath = destinationPath;
    }

    @Override
    public void onResponse(CompletableFuture<HttpResponse> responseFuture, Request request, HttpResponse response, Throwable throwable, int attempts, boolean canRetryOnADifferentHost, RetryAction retryAction) {
        if (response != null) {
            if (response.statusCode() == HttpResponseStatus.OK.code()) {
                this.logger.debug("Successfully downloaded file={}", (Object)this.destinationPath);
                responseFuture.complete(response);
                return;
            }
            if (response.statusCode() == HttpResponseStatus.NOT_FOUND.code() || response.statusCode() == HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE.code()) {
                this.logger.info("File not found at URI={}", (Object)request.requestURI());
                responseFuture.complete(response);
                return;
            }
        }
        this.delegate.onResponse(responseFuture, request, response, throwable, attempts, canRetryOnADifferentHost, retryAction);
    }
}

