/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.TableMetadata;
import com.linkedin.common.TimeStamp;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetProperties;
import datahub.event.MetadataChangeProposalWrapper;
import java.time.Instant;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.jetbrains.annotations.NotNull;

public class TableToDatasetPropertiesConverter
extends TableToAspectConverter<DatasetProperties> {
    public TableToDatasetPropertiesConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<DatasetProperties> convert(@NotNull TableMetadata table) {
        String urn = this.identifiers.urnDataset(table);
        DatasetProperties aspect = new DatasetProperties().setName(table.getName()).setQualifiedName(table.getKeyspace().getName() + "." + table.getName());
        String comment = table.getOptions().getComment();
        if (comment != null) {
            aspect = aspect.setDescription(comment);
        }
        aspect = aspect.setCreated(null, SetMode.REMOVE_IF_NULL).setLastModified(null, SetMode.REMOVE_IF_NULL);
        return this.wrap(urn, aspect);
    }

    @NotNull
    protected static TimeStamp convertTime(@NotNull Instant javaTime) {
        return new TimeStamp().setTime(javaTime.toEpochMilli());
    }
}

