/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.AbstractStringEncoderTest;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.codec.language.SoundexUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SoundexTest
extends AbstractStringEncoderTest<Soundex> {
    SoundexTest() {
    }

    @Override
    protected Soundex createStringEncoder() {
        return new Soundex();
    }

    @Test
    void testB650() throws EncoderException {
        this.checkEncodingVariations("B650", "BARHAM", "BARONE", "BARRON", "BERNA", "BIRNEY", "BIRNIE", "BOOROM", "BOREN", "BORN", "BOURN", "BOURNE", "BOWRON", "BRAIN", "BRAME", "BRANN", "BRAUN", "BREEN", "BRIEN", "BRIM", "BRIMM", "BRINN", "BRION", "BROOM", "BROOME", "BROWN", "BROWNE", "BRUEN", "BRUHN", "BRUIN", "BRUMM", "BRUN", "BRUNO", "BRYAN", "BURIAN", "BURN", "BURNEY", "BYRAM", "BYRNE", "BYRON", "BYRUM");
    }

    @Test
    void testBadCharacters() {
        Assertions.assertEquals((Object)"H452", (Object)((Soundex)this.getStringEncoder()).encode("HOL>MES"));
    }

    @Test
    void testDifference() throws EncoderException {
        Assertions.assertEquals((int)0, (int)((Soundex)this.getStringEncoder()).difference(null, null));
        Assertions.assertEquals((int)0, (int)((Soundex)this.getStringEncoder()).difference("", ""));
        Assertions.assertEquals((int)0, (int)((Soundex)this.getStringEncoder()).difference(" ", " "));
        Assertions.assertEquals((int)4, (int)((Soundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assertions.assertEquals((int)2, (int)((Soundex)this.getStringEncoder()).difference("Ann", "Andrew"));
        Assertions.assertEquals((int)1, (int)((Soundex)this.getStringEncoder()).difference("Margaret", "Andrew"));
        Assertions.assertEquals((int)0, (int)((Soundex)this.getStringEncoder()).difference("Janet", "Margaret"));
        Assertions.assertEquals((int)4, (int)((Soundex)this.getStringEncoder()).difference("Green", "Greene"));
        Assertions.assertEquals((int)0, (int)((Soundex)this.getStringEncoder()).difference("Blotchet-Halls", "Greene"));
        Assertions.assertEquals((int)4, (int)((Soundex)this.getStringEncoder()).difference("Smith", "Smythe"));
        Assertions.assertEquals((int)4, (int)((Soundex)this.getStringEncoder()).difference("Smithers", "Smythers"));
        Assertions.assertEquals((int)2, (int)((Soundex)this.getStringEncoder()).difference("Anothers", "Brothers"));
    }

    @Test
    void testEncodeBasic() {
        Assertions.assertEquals((Object)"T235", (Object)((Soundex)this.getStringEncoder()).encode("testing"));
        Assertions.assertEquals((Object)"T000", (Object)((Soundex)this.getStringEncoder()).encode("The"));
        Assertions.assertEquals((Object)"Q200", (Object)((Soundex)this.getStringEncoder()).encode("quick"));
        Assertions.assertEquals((Object)"B650", (Object)((Soundex)this.getStringEncoder()).encode("brown"));
        Assertions.assertEquals((Object)"F200", (Object)((Soundex)this.getStringEncoder()).encode("fox"));
        Assertions.assertEquals((Object)"J513", (Object)((Soundex)this.getStringEncoder()).encode("jumped"));
        Assertions.assertEquals((Object)"O160", (Object)((Soundex)this.getStringEncoder()).encode("over"));
        Assertions.assertEquals((Object)"T000", (Object)((Soundex)this.getStringEncoder()).encode("the"));
        Assertions.assertEquals((Object)"L200", (Object)((Soundex)this.getStringEncoder()).encode("lazy"));
        Assertions.assertEquals((Object)"D200", (Object)((Soundex)this.getStringEncoder()).encode("dogs"));
    }

    @Test
    void testEncodeBatch2() {
        Assertions.assertEquals((Object)"A462", (Object)((Soundex)this.getStringEncoder()).encode("Allricht"));
        Assertions.assertEquals((Object)"E166", (Object)((Soundex)this.getStringEncoder()).encode("Eberhard"));
        Assertions.assertEquals((Object)"E521", (Object)((Soundex)this.getStringEncoder()).encode("Engebrethson"));
        Assertions.assertEquals((Object)"H512", (Object)((Soundex)this.getStringEncoder()).encode("Heimbach"));
        Assertions.assertEquals((Object)"H524", (Object)((Soundex)this.getStringEncoder()).encode("Hanselmann"));
        Assertions.assertEquals((Object)"H431", (Object)((Soundex)this.getStringEncoder()).encode("Hildebrand"));
        Assertions.assertEquals((Object)"K152", (Object)((Soundex)this.getStringEncoder()).encode("Kavanagh"));
        Assertions.assertEquals((Object)"L530", (Object)((Soundex)this.getStringEncoder()).encode("Lind"));
        Assertions.assertEquals((Object)"L222", (Object)((Soundex)this.getStringEncoder()).encode("Lukaschowsky"));
        Assertions.assertEquals((Object)"M235", (Object)((Soundex)this.getStringEncoder()).encode("McDonnell"));
        Assertions.assertEquals((Object)"M200", (Object)((Soundex)this.getStringEncoder()).encode("McGee"));
        Assertions.assertEquals((Object)"O155", (Object)((Soundex)this.getStringEncoder()).encode("Opnian"));
        Assertions.assertEquals((Object)"O155", (Object)((Soundex)this.getStringEncoder()).encode("Oppenheimer"));
        Assertions.assertEquals((Object)"R355", (Object)((Soundex)this.getStringEncoder()).encode("Riedemanas"));
        Assertions.assertEquals((Object)"Z300", (Object)((Soundex)this.getStringEncoder()).encode("Zita"));
        Assertions.assertEquals((Object)"Z325", (Object)((Soundex)this.getStringEncoder()).encode("Zitzmeinn"));
    }

    @Test
    void testEncodeBatch3() {
        Assertions.assertEquals((Object)"W252", (Object)((Soundex)this.getStringEncoder()).encode("Washington"));
        Assertions.assertEquals((Object)"L000", (Object)((Soundex)this.getStringEncoder()).encode("Lee"));
        Assertions.assertEquals((Object)"G362", (Object)((Soundex)this.getStringEncoder()).encode("Gutierrez"));
        Assertions.assertEquals((Object)"P236", (Object)((Soundex)this.getStringEncoder()).encode("Pfister"));
        Assertions.assertEquals((Object)"J250", (Object)((Soundex)this.getStringEncoder()).encode("Jackson"));
        Assertions.assertEquals((Object)"T522", (Object)((Soundex)this.getStringEncoder()).encode("Tymczak"));
        Assertions.assertEquals((Object)"V532", (Object)((Soundex)this.getStringEncoder()).encode("VanDeusen"));
    }

    @Test
    void testEncodeBatch4() {
        Assertions.assertEquals((Object)"H452", (Object)((Soundex)this.getStringEncoder()).encode("HOLMES"));
        Assertions.assertEquals((Object)"A355", (Object)((Soundex)this.getStringEncoder()).encode("ADOMOMI"));
        Assertions.assertEquals((Object)"V536", (Object)((Soundex)this.getStringEncoder()).encode("VONDERLEHR"));
        Assertions.assertEquals((Object)"B400", (Object)((Soundex)this.getStringEncoder()).encode("BALL"));
        Assertions.assertEquals((Object)"S000", (Object)((Soundex)this.getStringEncoder()).encode("SHAW"));
        Assertions.assertEquals((Object)"J250", (Object)((Soundex)this.getStringEncoder()).encode("JACKSON"));
        Assertions.assertEquals((Object)"S545", (Object)((Soundex)this.getStringEncoder()).encode("SCANLON"));
        Assertions.assertEquals((Object)"S532", (Object)((Soundex)this.getStringEncoder()).encode("SAINTJOHN"));
    }

    @Test
    void testEncodeIgnoreApostrophes() throws EncoderException {
        this.checkEncodingVariations("O165", "OBrien", "'OBrien", "O'Brien", "OB'rien", "OBr'ien", "OBri'en", "OBrie'n", "OBrien'");
    }

    @Test
    void testEncodeIgnoreHyphens() throws EncoderException {
        this.checkEncodingVariations("K525", "KINGSMITH", "-KINGSMITH", "K-INGSMITH", "KI-NGSMITH", "KIN-GSMITH", "KING-SMITH", "KINGS-MITH", "KINGSM-ITH", "KINGSMI-TH", "KINGSMIT-H", "KINGSMITH-");
    }

    @Test
    void testEncodeIgnoreTrimmable() {
        Assertions.assertEquals((Object)"W252", (Object)((Soundex)this.getStringEncoder()).encode(" \t\n\r Washington \t\n\r "));
    }

    @Test
    void testGenealogy() {
        Soundex s = Soundex.US_ENGLISH_GENEALOGY;
        Assertions.assertEquals((Object)"H251", (Object)s.encode("Heggenburger"));
        Assertions.assertEquals((Object)"B425", (Object)s.encode("Blackman"));
        Assertions.assertEquals((Object)"S530", (Object)s.encode("Schmidt"));
        Assertions.assertEquals((Object)"L150", (Object)s.encode("Lippmann"));
        Assertions.assertEquals((Object)"D200", (Object)s.encode("Dodds"));
        Assertions.assertEquals((Object)"D200", (Object)s.encode("Dhdds"));
        Assertions.assertEquals((Object)"D200", (Object)s.encode("Dwdds"));
    }

    @Test
    void testHWRuleEx1() {
        Assertions.assertEquals((Object)"A261", (Object)((Soundex)this.getStringEncoder()).encode("Ashcraft"));
        Assertions.assertEquals((Object)"A261", (Object)((Soundex)this.getStringEncoder()).encode("Ashcroft"));
        Assertions.assertEquals((Object)"Y330", (Object)((Soundex)this.getStringEncoder()).encode("yehudit"));
        Assertions.assertEquals((Object)"Y330", (Object)((Soundex)this.getStringEncoder()).encode("yhwdyt"));
    }

    @Test
    void testHWRuleEx2() {
        Assertions.assertEquals((Object)"B312", (Object)((Soundex)this.getStringEncoder()).encode("BOOTHDAVIS"));
        Assertions.assertEquals((Object)"B312", (Object)((Soundex)this.getStringEncoder()).encode("BOOTH-DAVIS"));
    }

    @Test
    void testHWRuleEx3() throws EncoderException {
        Assertions.assertEquals((Object)"S460", (Object)((Soundex)this.getStringEncoder()).encode("Sgler"));
        Assertions.assertEquals((Object)"S460", (Object)((Soundex)this.getStringEncoder()).encode("Swhgler"));
        this.checkEncodingVariations("S460", "SAILOR", "SALYER", "SAYLOR", "SCHALLER", "SCHELLER", "SCHILLER", "SCHOOLER", "SCHULER", "SCHUYLER", "SEILER", "SEYLER", "SHOLAR", "SHULER", "SILAR", "SILER", "SILLER");
    }

    @Test
    void testMsSqlServer1() {
        Assertions.assertEquals((Object)"S530", (Object)((Soundex)this.getStringEncoder()).encode("Smith"));
        Assertions.assertEquals((Object)"S530", (Object)((Soundex)this.getStringEncoder()).encode("Smythe"));
    }

    @Test
    void testMsSqlServer2() throws EncoderException {
        this.checkEncodingVariations("E625", "Erickson", "Erickson", "Erikson", "Ericson", "Ericksen", "Ericsen");
    }

    @Test
    void testMsSqlServer3() {
        Assertions.assertEquals((Object)"A500", (Object)((Soundex)this.getStringEncoder()).encode("Ann"));
        Assertions.assertEquals((Object)"A536", (Object)((Soundex)this.getStringEncoder()).encode("Andrew"));
        Assertions.assertEquals((Object)"J530", (Object)((Soundex)this.getStringEncoder()).encode("Janet"));
        Assertions.assertEquals((Object)"M626", (Object)((Soundex)this.getStringEncoder()).encode("Margaret"));
        Assertions.assertEquals((Object)"S315", (Object)((Soundex)this.getStringEncoder()).encode("Steven"));
        Assertions.assertEquals((Object)"M240", (Object)((Soundex)this.getStringEncoder()).encode("Michael"));
        Assertions.assertEquals((Object)"R163", (Object)((Soundex)this.getStringEncoder()).encode("Robert"));
        Assertions.assertEquals((Object)"L600", (Object)((Soundex)this.getStringEncoder()).encode("Laura"));
        Assertions.assertEquals((Object)"A500", (Object)((Soundex)this.getStringEncoder()).encode("Anne"));
    }

    @Test
    void testNewInstance() {
        Assertions.assertEquals((Object)"W452", (Object)new Soundex().soundex("Williams"));
    }

    @Test
    void testNewInstance2() {
        Assertions.assertEquals((Object)"W452", (Object)new Soundex("01230120022455012623010202".toCharArray()).soundex("Williams"));
    }

    @Test
    void testNewInstance3() {
        Assertions.assertEquals((Object)"W452", (Object)new Soundex("01230120022455012623010202").soundex("Williams"));
    }

    @Test
    void testSimplifiedSoundex() {
        Soundex s = Soundex.US_ENGLISH_SIMPLIFIED;
        Assertions.assertEquals((Object)"W452", (Object)s.encode("WILLIAMS"));
        Assertions.assertEquals((Object)"B625", (Object)s.encode("BARAGWANATH"));
        Assertions.assertEquals((Object)"D540", (Object)s.encode("DONNELL"));
        Assertions.assertEquals((Object)"L300", (Object)s.encode("LLOYD"));
        Assertions.assertEquals((Object)"W422", (Object)s.encode("WOOLCOCK"));
        Assertions.assertEquals((Object)"D320", (Object)s.encode("Dodds"));
        Assertions.assertEquals((Object)"D320", (Object)s.encode("Dwdds"));
        Assertions.assertEquals((Object)"D320", (Object)s.encode("Dhdds"));
    }

    @Test
    void testSoundexUtilsConstructable() {
        new SoundexUtils();
    }

    @Test
    void testSoundexUtilsNullBehaviour() {
        Assertions.assertNull((Object)SoundexUtils.clean(null));
        Assertions.assertEquals((Object)"", (Object)SoundexUtils.clean((String)""));
        Assertions.assertEquals((int)0, (int)SoundexUtils.differenceEncoded(null, (String)""));
        Assertions.assertEquals((int)0, (int)SoundexUtils.differenceEncoded((String)"", null));
    }

    @Test
    void testUsEnglishStatic() {
        Assertions.assertEquals((Object)"W452", (Object)Soundex.US_ENGLISH.soundex("Williams"));
    }

    @Test
    void testUsMappingEWithAcute() {
        Assertions.assertEquals((Object)"E000", (Object)((Soundex)this.getStringEncoder()).encode("e"));
        if (Character.isLetter('\u00e9')) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((Soundex)this.getStringEncoder()).encode("\u00e9"));
        } else {
            Assertions.assertEquals((Object)"", (Object)((Soundex)this.getStringEncoder()).encode("\u00e9"));
        }
    }

    @Test
    void testUsMappingOWithDiaeresis() {
        Assertions.assertEquals((Object)"O000", (Object)((Soundex)this.getStringEncoder()).encode("o"));
        if (Character.isLetter('\u00f6')) {
            Assertions.assertThrows(IllegalArgumentException.class, () -> ((Soundex)this.getStringEncoder()).encode("\u00f6"));
        } else {
            Assertions.assertEquals((Object)"", (Object)((Soundex)this.getStringEncoder()).encode("\u00f6"));
        }
    }

    @Test
    void testWikipediaAmericanSoundex() {
        Assertions.assertEquals((Object)"R163", (Object)((Soundex)this.getStringEncoder()).encode("Robert"));
        Assertions.assertEquals((Object)"R163", (Object)((Soundex)this.getStringEncoder()).encode("Rupert"));
        Assertions.assertEquals((Object)"A261", (Object)((Soundex)this.getStringEncoder()).encode("Ashcraft"));
        Assertions.assertEquals((Object)"A261", (Object)((Soundex)this.getStringEncoder()).encode("Ashcroft"));
        Assertions.assertEquals((Object)"T522", (Object)((Soundex)this.getStringEncoder()).encode("Tymczak"));
        Assertions.assertEquals((Object)"P236", (Object)((Soundex)this.getStringEncoder()).encode("Pfister"));
    }
}

