/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GeneralPurposeBitTest {
    GeneralPurposeBitTest() {
    }

    @Test
    void testClone() {
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useStrongEncryption(true);
        b.useUTF8ForNames(true);
        Assertions.assertEquals((Object)b, (Object)b.clone());
        Assertions.assertNotSame((Object)b, (Object)b.clone());
    }

    @Test
    void testDataDescriptor() {
        byte[] flags = new byte[]{8, 0};
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesDataDescriptor());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useDataDescriptor(true);
        Assertions.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    void testDefaults() {
        Assertions.assertFalse((boolean)new GeneralPurposeBit().usesDataDescriptor());
        Assertions.assertFalse((boolean)new GeneralPurposeBit().usesUTF8ForNames());
        Assertions.assertFalse((boolean)new GeneralPurposeBit().usesEncryption());
        Assertions.assertFalse((boolean)new GeneralPurposeBit().usesStrongEncryption());
        byte[] b = new byte[2];
        Assertions.assertArrayEquals((byte[])b, (byte[])new GeneralPurposeBit().encode());
    }

    @Test
    void testEncryption() {
        byte[] flags = new byte[]{1, 0};
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useEncryption(true);
        Assertions.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    void testLanguageEncodingFlag() {
        byte[] flags = new byte[]{0, 8};
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesUTF8ForNames());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useUTF8ForNames(true);
        Assertions.assertArrayEquals((byte[])flags, (byte[])b.encode());
    }

    @Test
    void testParseEdgeCases() {
        Assertions.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesDataDescriptor());
        Assertions.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesUTF8ForNames());
        Assertions.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesEncryption());
        Assertions.assertFalse((boolean)GeneralPurposeBit.parse((byte[])new byte[2], (int)0).usesStrongEncryption());
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesDataDescriptor());
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesUTF8ForNames());
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesEncryption());
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])new byte[]{-1, -1}, (int)0).usesStrongEncryption());
    }

    @Test
    void testStrongEncryption() {
        byte[] flags = new byte[]{65, 0};
        Assertions.assertTrue((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
        GeneralPurposeBit b = new GeneralPurposeBit();
        b.useStrongEncryption(true);
        Assertions.assertTrue((boolean)b.usesEncryption());
        Assertions.assertArrayEquals((byte[])flags, (byte[])b.encode());
        flags = new byte[]{64, 0};
        Assertions.assertFalse((boolean)GeneralPurposeBit.parse((byte[])flags, (int)0).usesStrongEncryption());
    }
}

