/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.IOException;
import org.apache.commons.compress.MemoryLimitException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MemoryLimitExceptionTest {
    MemoryLimitExceptionTest() {
    }

    @Test
    void testAccessorsCause() {
        IOException ioe = new IOException();
        MemoryLimitException e = new MemoryLimitException(1L, 2, (Throwable)ioe);
        Assertions.assertEquals((long)1L, (long)e.getMemoryNeededInKb());
        Assertions.assertEquals((int)2, (int)e.getMemoryLimitInKb());
        Assert.assertSame((Object)ioe, (Object)e.getCause());
    }

    @Test
    void testAccessorsCauseDepreacted() {
        IOException ioe = new IOException();
        MemoryLimitException e = new MemoryLimitException(1L, 2, (Exception)ioe);
        Assertions.assertEquals((long)1L, (long)e.getMemoryNeededInKb());
        Assertions.assertEquals((int)2, (int)e.getMemoryLimitInKb());
        Assert.assertSame((Object)ioe, (Object)e.getCause());
    }

    @Test
    void testAccessorsLimit() {
        MemoryLimitException e = new MemoryLimitException(1L, 2);
        Assertions.assertEquals((long)1L, (long)e.getMemoryNeededInKb());
        Assertions.assertEquals((int)2, (int)e.getMemoryLimitInKb());
    }
}

