/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class ArArchiveInputStreamTest
extends AbstractTest {
    ArArchiveInputStreamTest() {
    }

    private void checkLongNameEntry(String archive) throws Exception {
        try (InputStream fis = ArArchiveInputStreamTest.newInputStream(archive);
             ArArchiveInputStream s = new ArArchiveInputStream((InputStream)new BufferedInputStream(fis));){
            ArArchiveEntry e = s.getNextEntry();
            Assertions.assertEquals((Object)"this_is_a_long_file_name.txt", (Object)e.getName());
            Assertions.assertEquals((long)14L, (long)e.getSize());
            byte[] hello = new byte[14];
            s.read(hello);
            Assertions.assertEquals((Object)"Hello, world!\n", (Object)ArchiveUtils.toAsciiString((byte[])hello));
            e = s.getNextEntry();
            Assertions.assertEquals((Object)"this_is_a_long_file_name_as_well.txt", (Object)e.getName());
            Assertions.assertEquals((long)4L, (long)e.getSize());
            byte[] bye = new byte[4];
            s.read(bye);
            Assertions.assertEquals((Object)"Bye\n", (Object)ArchiveUtils.toAsciiString((byte[])bye));
            Assertions.assertNull((Object)s.getNextEntry());
        }
    }

    @Test
    void testCantReadAfterClose() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            archive.close();
            Assertions.assertThrows(IllegalStateException.class, () -> archive.read());
        }
    }

    @Test
    void testCantReadWithoutOpeningAnEntry() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertThrows(IllegalStateException.class, () -> archive.read());
        }
    }

    @Test
    void testCompress661() throws IOException {
        this.testCompress661(false);
        this.testCompress661(true);
    }

    private void testCompress661(boolean checkMarkReadReset) throws IOException {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("org/apache/commons/compress/COMPRESS-661/testARofText.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream((InputStream)new BufferedInputStream(in));){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            if (checkMarkReadReset && archive.markSupported()) {
                archive.mark(10);
                archive.read(new byte[10]);
                archive.reset();
            }
            byte[] ba = IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((Object)"Test d'indexation de Txt\nhttp://www.apache.org\n", (Object)new String(ba));
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertNull((Object)archive.getNextEntry());
        }
    }

    @Test
    void testInvalidBadTableLength() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("org/apache/commons/compress/ar/number_parsing/bad_table_length_gnu-fail.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> ((ArArchiveInputStream)archive).getNextEntry());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bad_long_namelen_bsd-fail.ar", "bad_long_namelen_gnu1-fail.ar", "bad_long_namelen_gnu2-fail.ar", "bad_long_namelen_gnu3-fail.ar", "bad_table_length_gnu-fail.ar"})
    void testInvalidLongNameLength(String testFileName) throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("org/apache/commons/compress/ar/number_parsing/" + testFileName);
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> ((ArArchiveInputStream)archive).getNextEntry());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"bad_group-fail.ar", "bad_length-fail.ar", "bad_modified-fail.ar", "bad_user-fail.ar"})
    void testInvalidNumericFields(String testFileName) throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("org/apache/commons/compress/ar/number_parsing/" + testFileName);
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertThrows(IOException.class, () -> ((ArArchiveInputStream)archive).getNextEntry());
        }
    }

    @Test
    void testMultiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
            Assertions.assertEquals((int)-1, (int)archive.read(buf));
        }
    }

    @Test
    void testReadLongNamesBSD() throws Exception {
        this.checkLongNameEntry("longfile_bsd.ar");
    }

    @Test
    void testReadLongNamesGNU() throws Exception {
        this.checkLongNameEntry("longfile_gnu.ar");
    }

    @Test
    void testSimpleInputStream() throws IOException {
        try (final InputStream fileInputStream = ArArchiveInputStreamTest.newInputStream("bla.ar");
             InputStream simpleInputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return fileInputStream.read();
            }
        };
             ArArchiveInputStream archiveInputStream = new ArArchiveInputStream(simpleInputStream);){
            ArArchiveEntry entry1 = archiveInputStream.getNextEntry();
            Assertions.assertNotNull((Object)entry1);
            Assertions.assertEquals((Object)"test1.xml", (Object)entry1.getName());
            Assertions.assertEquals((long)610L, (long)entry1.getLength());
            ArArchiveEntry entry2 = archiveInputStream.getNextEntry();
            Assertions.assertEquals((Object)"test2.xml", (Object)entry2.getName());
            Assertions.assertEquals((long)82L, (long)entry2.getLength());
            Assertions.assertNull((Object)archiveInputStream.getNextEntry());
        }
    }

    @Test
    void testSimpleInputStreamDeprecated() throws IOException {
        try (final InputStream fileInputStream = ArArchiveInputStreamTest.newInputStream("bla.ar");
             InputStream simpleInputStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return fileInputStream.read();
            }
        };
             ArArchiveInputStream archiveInputStream = new ArArchiveInputStream(simpleInputStream);){
            ArArchiveEntry entry1 = archiveInputStream.getNextArEntry();
            Assertions.assertNotNull((Object)entry1);
            Assertions.assertEquals((Object)"test1.xml", (Object)entry1.getName());
            Assertions.assertEquals((long)610L, (long)entry1.getLength());
            ArArchiveEntry entry2 = archiveInputStream.getNextArEntry();
            Assertions.assertEquals((Object)"test2.xml", (Object)entry2.getName());
            Assertions.assertEquals((long)82L, (long)entry2.getLength());
            Assertions.assertNull((Object)archiveInputStream.getNextArEntry());
        }
    }

    @Test
    void testSingleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (InputStream in = ArArchiveInputStreamTest.newInputStream("bla.ar");
             ArArchiveInputStream archive = new ArArchiveInputStream(in);){
            Assertions.assertNotNull((Object)archive.getNextEntry());
            IOUtils.toByteArray((InputStream)archive);
            Assertions.assertEquals((int)-1, (int)archive.read());
            Assertions.assertEquals((int)-1, (int)archive.read());
        }
    }
}

