/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pnm;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.formats.pnm.PnmImageParser;
import org.apache.commons.imaging.formats.pnm.PnmImagingParameters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PnmImageParserTest {
    private static final Charset US_ASCII = StandardCharsets.US_ASCII;

    @Test
    public void testGetImageInfo_happyCase() throws ImagingException, IOException {
        byte[] bytes = "P1\n3 2\n0 1 0\n1 0 1\n".getBytes(US_ASCII);
        PnmImagingParameters params = new PnmImagingParameters();
        PnmImageParser underTest = new PnmImageParser();
        ImageInfo results = underTest.getImageInfo(bytes, (ImagingParameters)params);
        Assertions.assertEquals((int)results.getBitsPerPixel(), (int)1);
        Assertions.assertEquals((int)results.getWidth(), (int)3);
        Assertions.assertEquals((int)results.getHeight(), (int)2);
        Assertions.assertEquals((int)results.getNumberOfImages(), (int)1);
    }

    @Test
    public void testGetImageInfo_invalidHeight() {
        byte[] bytes = "P1\n2 a\n0 0\n0 0\n0 0\n0 0\n0 0\n0 1\n1 1\n1 1\n1 1\n1 1\n1 1\n".getBytes(US_ASCII);
        PnmImagingParameters params = new PnmImagingParameters();
        PnmImageParser underTest = new PnmImageParser();
        Assertions.assertThrows(ImagingException.class, () -> underTest.getImageInfo(bytes, (ImagingParameters)params));
    }

    @Test
    public void testGetImageInfo_invalidWidth() {
        byte[] bytes = "P1\na 2\n0 0 0 0 0 0 0 0 0 0 0\n1 1 1 1 1 1 1 1 1 1 1\n".getBytes(US_ASCII);
        PnmImagingParameters params = new PnmImagingParameters();
        PnmImageParser underTest = new PnmImageParser();
        Assertions.assertThrows(ImagingException.class, () -> underTest.getImageInfo(bytes, (ImagingParameters)params));
    }

    @Test
    public void testGetImageInfo_missingWidthValue() {
        byte[] bytes = "P7\nWIDTH \n".getBytes(US_ASCII);
        PnmImagingParameters params = new PnmImagingParameters();
        PnmImageParser underTest = new PnmImageParser();
        Assertions.assertThrows(ImagingException.class, () -> underTest.getImageInfo(bytes, (ImagingParameters)params));
    }

    @Test
    public void testWriteImageRaw_happyCase() throws ImagingException, ImagingException, IOException {
        BufferedImage srcImage = new BufferedImage(10, 10, 2);
        byte[] dstBytes = Imaging.writeImageToBytes((BufferedImage)srcImage, (ImageFormat)ImageFormats.PNM);
        BufferedImage dstImage = Imaging.getBufferedImage((byte[])dstBytes);
        Assertions.assertEquals((int)srcImage.getWidth(), (int)dstImage.getWidth());
        Assertions.assertEquals((int)srcImage.getHeight(), (int)dstImage.getHeight());
        DataBufferInt srcData = (DataBufferInt)srcImage.getRaster().getDataBuffer();
        DataBufferInt dstData = (DataBufferInt)dstImage.getRaster().getDataBuffer();
        for (int bank = 0; bank < srcData.getNumBanks(); ++bank) {
            int[] actual = srcData.getData(bank);
            int[] expected = dstData.getData(bank);
            Assertions.assertArrayEquals((int[])actual, (int[])expected);
        }
    }
}

