/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public abstract class AbstractPathWrapper
implements Path {
    private final Path path;

    protected AbstractPathWrapper(Path path) {
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public int compareTo(Path other) {
        return this.path.compareTo(other);
    }

    @Override
    public boolean endsWith(Path other) {
        return this.path.endsWith(other);
    }

    @Override
    public boolean endsWith(String other) {
        return this.path.endsWith(other);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPathWrapper)) {
            return false;
        }
        AbstractPathWrapper other = (AbstractPathWrapper)obj;
        return Objects.equals(this.path, other.path);
    }

    public boolean exists(LinkOption ... options) {
        return Files.exists(this.path, options);
    }

    @Override
    public void forEach(Consumer<? super Path> action) {
        this.path.forEach(action);
    }

    public Path get() {
        return this.path;
    }

    @Override
    public Path getFileName() {
        return this.path.getFileName();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.path.getFileSystem();
    }

    @Override
    public Path getName(int index) {
        return this.path.getName(index);
    }

    @Override
    public int getNameCount() {
        return this.path.getNameCount();
    }

    @Override
    public Path getParent() {
        return this.path.getParent();
    }

    @Override
    public Path getRoot() {
        return this.path.getRoot();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.path);
    }

    @Override
    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    @Override
    public Iterator<Path> iterator() {
        return this.path.iterator();
    }

    @Override
    public Path normalize() {
        return this.path.normalize();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.path.register(watcher, events);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.path.register(watcher, events, modifiers);
    }

    @Override
    public Path relativize(Path other) {
        return this.path.relativize(other);
    }

    @Override
    public Path resolve(Path other) {
        return this.path.resolve(other);
    }

    @Override
    public Path resolve(String other) {
        return this.path.resolve(other);
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.path.resolveSibling(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.path.resolveSibling(other);
    }

    @Override
    public Spliterator<Path> spliterator() {
        return this.path.spliterator();
    }

    @Override
    public boolean startsWith(Path other) {
        return this.path.startsWith(other);
    }

    @Override
    public boolean startsWith(String other) {
        return this.path.startsWith(other);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.path.subpath(beginIndex, endIndex);
    }

    @Override
    public Path toAbsolutePath() {
        return this.path.toAbsolutePath();
    }

    @Override
    public File toFile() {
        return this.path.toFile();
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.path.toRealPath(options);
    }

    @Override
    public String toString() {
        return this.path.toString();
    }

    @Override
    public URI toUri() {
        return this.path.toUri();
    }
}

