/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.LangAttributePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;

public class BeanAttributeIterator
extends PropertyIterator {
    private final NodePointer parent;
    private int position;
    private final boolean includeXmlLang;

    public BeanAttributeIterator(PropertyOwnerPointer parent, QName qName) {
        super(parent, (String)(qName.getPrefix() == null && (qName.getName() == null || qName.getName().equals("*")) ? null : qName.toString()), false, null);
        this.parent = parent;
        this.includeXmlLang = qName.getPrefix() != null && qName.getPrefix().equals("xml") && (qName.getName().equals("lang") || qName.getName().equals("*"));
    }

    @Override
    public NodePointer getNodePointer() {
        return this.includeXmlLang && this.position == 1 ? new LangAttributePointer(this.parent) : super.getNodePointer();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean setPosition(int position) {
        this.position = position;
        if (this.includeXmlLang) {
            return position == 1 || super.setPosition(position - 1);
        }
        return super.setPosition(position);
    }
}

