/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.commons.validator.CreditCardValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class CreditCardValidatorTest {
    private static final String VALID_VISA = "4417123456789113";
    private static final String VALID_SHORT_VISA = "4222222222222";
    private static final String VALID_AMEX = "378282246310005";
    private static final String VALID_MASTERCARD = "5105105105105100";
    private static final String VALID_DISCOVER = "6011000990139424";
    private static final String VALID_DINERS = "30569309025904";

    CreditCardValidatorTest() {
    }

    @Test
    void testAddAllowedCardType() {
        CreditCardValidator ccv = new CreditCardValidator(0);
        Assertions.assertFalse((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_AMEX));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        Assertions.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        ccv.addAllowedCardType((CreditCardValidator.CreditCardType)new DinersClub());
        Assertions.assertTrue((boolean)ccv.isValid(VALID_DINERS));
    }

    @Test
    void testIsValid() {
        CreditCardValidator ccv = new CreditCardValidator();
        Assertions.assertFalse((boolean)ccv.isValid(null));
        Assertions.assertFalse((boolean)ccv.isValid(""));
        Assertions.assertFalse((boolean)ccv.isValid("123456789012"));
        Assertions.assertFalse((boolean)ccv.isValid("12345678901234567890"));
        Assertions.assertFalse((boolean)ccv.isValid("4417123456789112"));
        Assertions.assertFalse((boolean)ccv.isValid("4417q23456w89113"));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_MASTERCARD));
        Assertions.assertTrue((boolean)ccv.isValid(VALID_DISCOVER));
        ccv = new CreditCardValidator(1);
        Assertions.assertFalse((boolean)ccv.isValid(VALID_VISA));
    }

    private static class DinersClub
    implements CreditCardValidator.CreditCardType {
        private static final String PREFIX = "300,301,302,303,304,305,";

        private DinersClub() {
        }

        public boolean matches(String card) {
            String prefix = card.substring(0, 3) + ",";
            return PREFIX.contains(prefix) && card.length() == 14;
        }
    }
}

