/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.spring.web;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.spring.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class FederationLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FederationLogoutSuccessHandler.class);
    private FederationConfig federationConfig;

    @Required
    public void setFederationConfig(FederationConfig federationConfig) {
        this.federationConfig = federationConfig;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String contextName = request.getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        FedizContext fedCtx = this.federationConfig.getFedizContext(contextName);
        try {
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedCtx.getProtocol());
            RedirectionResponse redirectionResponse = wfProc.createSignOutRequest(request, null, fedCtx);
            String redirectURL = redirectionResponse.getRedirectionURL();
            if (redirectURL != null) {
                Map headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (Map.Entry entry : headers.entrySet()) {
                        response.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                response.sendRedirect(redirectURL);
            } else {
                LOG.warn("Failed to create SignOutRequest.");
                response.sendError(500, "Failed to create SignOutRequest.");
            }
        }
        catch (ProcessingException ex) {
            LOG.warn("Failed to create SignOutRequest: " + ex.getMessage());
            response.sendError(500, "Failed to create SignOutRequest.");
        }
    }
}

