/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dpath;

import java.io.Serializable;
import org.apache.daffodil.core.dpath.Expression;
import org.apache.daffodil.core.dpath.ExpressionLists;
import org.apache.daffodil.core.dpath.PathExpression;
import org.apache.daffodil.lib.xml.RefQName;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class FunctionCallBase
extends ExpressionLists {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FunctionCallBase.class.getDeclaredField("targetType$lzy5"));
    private final String functionQNameString;
    private final RefQName functionQName;
    private final List<Expression> expressions;
    private volatile Object targetType$lzy5;

    public FunctionCallBase(String functionQNameString, RefQName functionQName, List<Expression> expressions) {
        this.functionQNameString = functionQNameString;
        this.functionQName = functionQName;
        this.expressions = expressions;
        super(expressions);
    }

    @Override
    public String text() {
        return this.functionQNameString + "(" + this.expressions.map((Function1 & Serializable)_$285 -> _$285.text()).mkString(", ") + ")";
    }

    @Override
    public NodeInfo.Kind targetType() {
        Object object = this.targetType$lzy5;
        if (object instanceof NodeInfo.Kind) {
            return (NodeInfo.Kind)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (NodeInfo.Kind)this.targetType$lzyINIT5();
    }

    private Object targetType$lzyINIT5() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.targetType$lzy5) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    NodeInfo.Kind kind = null;
                    try {
                        NodeInfo.Kind res;
                        kind = res = this.parent().targetType();
                        object2 = kind == null ? LazyVals.NullValue$.MODULE$ : kind;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.targetType$lzy5;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return kind;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void checkArgArrayOrOptional(int n) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        if (!this.isArrayOrOptional$1(lazyBoolean, n)) {
            throw this.argArrayOrOptionalErr();
        }
    }

    public Nothing$ argArrayOrOptionalErr() {
        return this.SDE("The %s function requires an array or optional path expression.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.functionQName.toPrettyString()}));
    }

    public final void checkArgCount(int n) {
        if (this.expressions.length() != n) {
            throw this.argCountErr(n);
        }
    }

    public final Nothing$ argCountErr(int n) {
        return this.SDE("The %s function requires %s argument(s).", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.functionQName.toPrettyString(), BoxesRunTime.boxToInteger((int)n)}));
    }

    public final Nothing$ argCountTooFewErr(int n) {
        return this.SDE("The %s function requires at least %s argument(s).", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.functionQName.toPrettyString(), BoxesRunTime.boxToInteger((int)n)}));
    }

    public final Nothing$ argCountTooManyErr(int n) {
        return this.SDE("The %s function requires no more than %s argument(s).", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.functionQName.toPrettyString(), BoxesRunTime.boxToInteger((int)n)}));
    }

    private final boolean isArrayOrOptional$lzyINIT2$1(LazyBoolean isArrayOrOptional$lzy2$1, int n$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isArrayOrOptional$lzy2$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (isArrayOrOptional$lzy2$1.initialized()) {
                bl2 = isArrayOrOptional$lzy2$1.value();
            } else {
                boolean bl3;
                Expression expression = (Expression)this.expressions.apply(n$1);
                if (expression instanceof PathExpression) {
                    PathExpression pe = (PathExpression)expression;
                    bl3 = pe.isPathToOneWholeArrayOrOptional();
                } else {
                    bl3 = false;
                }
                bl2 = isArrayOrOptional$lzy2$1.initialize(bl3);
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean isArrayOrOptional$1(LazyBoolean isArrayOrOptional$lzy2$2, int n$2) {
        if (isArrayOrOptional$lzy2$2.initialized()) {
            return isArrayOrOptional$lzy2$2.value();
        }
        return this.isArrayOrOptional$lzyINIT2$1(isArrayOrOptional$lzy2$2, n$2);
    }
}

