/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public enum PrimitiveUType {
    DOCUMENT(0),
    ELEMENT(1),
    ATTRIBUTE(2),
    TEXT(3),
    COMMENT(4),
    PI(5),
    NAMESPACE(6),
    FUNCTION(7),
    STRING(8),
    BOOLEAN(9),
    DECIMAL(10),
    FLOAT(11),
    DOUBLE(12),
    DURATION(13),
    DATE_TIME(14),
    TIME(15),
    DATE(16),
    G_YEAR_MONTH(17),
    G_YEAR(18),
    G_MONTH_DAY(19),
    G_DAY(20),
    G_MONTH(21),
    HEX_BINARY(22),
    BASE64_BINARY(23),
    ANY_URI(24),
    QNAME(25),
    NOTATION(26),
    UNTYPED_ATOMIC(27),
    EXTENSION(30);

    private final int bit;

    private PrimitiveUType(int bit) {
        this.bit = bit;
    }

    public int getBit() {
        return this.bit;
    }

    public UType toUType() {
        return new UType(1 << this.bit);
    }

    public static PrimitiveUType forBit(int bit) {
        return PrimitiveUType.values()[bit];
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "document";
            }
            case 1: {
                return "element";
            }
            case 2: {
                return "attribute";
            }
            case 3: {
                return "text";
            }
            case 4: {
                return "comment";
            }
            case 5: {
                return "processing-instruction";
            }
            case 6: {
                return "namespace";
            }
            case 7: {
                return "function";
            }
            case 8: {
                return "string";
            }
            case 9: {
                return "boolean";
            }
            case 10: {
                return "decimal";
            }
            case 11: {
                return "float";
            }
            case 12: {
                return "double";
            }
            case 13: {
                return "duration";
            }
            case 14: {
                return "dateTime";
            }
            case 15: {
                return "time";
            }
            case 16: {
                return "date";
            }
            case 17: {
                return "gYearMonth";
            }
            case 18: {
                return "gYear";
            }
            case 19: {
                return "gMonthDay";
            }
            case 20: {
                return "gDay";
            }
            case 21: {
                return "gMoonth";
            }
            case 22: {
                return "hexBinary";
            }
            case 23: {
                return "base64Binary";
            }
            case 24: {
                return "anyURI";
            }
            case 25: {
                return "QName";
            }
            case 26: {
                return "NOTATION";
            }
            case 27: {
                return "untypedAtomic";
            }
            case 28: {
                return "external object";
            }
        }
        return "???";
    }

    public ItemType toItemType() {
        switch (this.ordinal()) {
            case 0: {
                return NodeKindTest.DOCUMENT;
            }
            case 1: {
                return NodeKindTest.ELEMENT;
            }
            case 2: {
                return NodeKindTest.ATTRIBUTE;
            }
            case 3: {
                return NodeKindTest.TEXT;
            }
            case 4: {
                return NodeKindTest.COMMENT;
            }
            case 5: {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
            case 6: {
                return NodeKindTest.NAMESPACE;
            }
            case 7: {
                return AnyFunctionType.getInstance();
            }
            case 8: {
                return BuiltInAtomicType.STRING;
            }
            case 9: {
                return BuiltInAtomicType.BOOLEAN;
            }
            case 10: {
                return BuiltInAtomicType.DECIMAL;
            }
            case 11: {
                return BuiltInAtomicType.FLOAT;
            }
            case 12: {
                return BuiltInAtomicType.DOUBLE;
            }
            case 13: {
                return BuiltInAtomicType.DURATION;
            }
            case 14: {
                return BuiltInAtomicType.DATE_TIME;
            }
            case 15: {
                return BuiltInAtomicType.TIME;
            }
            case 16: {
                return BuiltInAtomicType.DATE;
            }
            case 17: {
                return BuiltInAtomicType.G_YEAR_MONTH;
            }
            case 18: {
                return BuiltInAtomicType.G_YEAR;
            }
            case 19: {
                return BuiltInAtomicType.G_MONTH_DAY;
            }
            case 20: {
                return BuiltInAtomicType.G_DAY;
            }
            case 21: {
                return BuiltInAtomicType.G_MONTH;
            }
            case 22: {
                return BuiltInAtomicType.HEX_BINARY;
            }
            case 23: {
                return BuiltInAtomicType.BASE64_BINARY;
            }
            case 24: {
                return BuiltInAtomicType.ANY_URI;
            }
            case 25: {
                return BuiltInAtomicType.QNAME;
            }
            case 26: {
                return BuiltInAtomicType.NOTATION;
            }
            case 27: {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            case 28: {
                return AnyItemType.getInstance();
            }
        }
        throw new IllegalArgumentException();
    }
}

