/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.arrayofdoubles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesAnotB;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCompactSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUpdatableSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayOfDoublesAnotBTest {
    @Test
    public void nullOrEmptyInput() {
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        try {
            aNotB.update((ArrayOfDoublesSketch)sketch, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            aNotB.update(null, (ArrayOfDoublesSketch)sketch);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        aNotB.update((ArrayOfDoublesSketch)sketch, (ArrayOfDoublesSketch)sketch);
        result = aNotB.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void emptyA() {
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(1L, new double[]{1.0});
        sketchB.update(2L, new double[]{1.0});
        sketchB.update(3L, new double[]{1.0});
        sketchB.update(4L, new double[]{1.0});
        sketchB.update(5L, new double[]{1.0});
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void emptyB() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{1.0});
        sketchA.update(2L, new double[]{1.0});
        sketchA.update(3L, new double[]{1.0});
        sketchA.update(4L, new double[]{1.0});
        sketchA.update(5L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)5);
        Assert.assertEquals((double)result.getEstimate(), (double)5.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)5.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)5.0);
        ArrayOfDoublesSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
    }

    @Test
    public void aSameAsB() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketch.update(1L, new double[]{1.0});
        sketch.update(2L, new double[]{1.0});
        sketch.update(3L, new double[]{1.0});
        sketch.update(4L, new double[]{1.0});
        sketch.update(5L, new double[]{1.0});
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketch, (ArrayOfDoublesSketch)sketch);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertTrue((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)0);
        Assert.assertEquals((double)result.getEstimate(), (double)0.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)0.0);
    }

    @Test
    public void exactMode() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchA.update(1L, new double[]{1.0});
        sketchA.update(2L, new double[]{1.0});
        sketchA.update(3L, new double[]{1.0});
        sketchA.update(4L, new double[]{1.0});
        sketchA.update(5L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        sketchB.update(3L, new double[]{1.0});
        sketchB.update(4L, new double[]{1.0});
        sketchB.update(5L, new double[]{1.0});
        sketchB.update(6L, new double[]{1.0});
        sketchB.update(7L, new double[]{1.0});
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)2);
        Assert.assertEquals((double)result.getEstimate(), (double)2.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)2.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)2.0);
        ArrayOfDoublesSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
    }

    @Test
    public void exactModeTwoDoubles() {
        ArrayOfDoublesUpdatableSketchBuilder bldr = new ArrayOfDoublesUpdatableSketchBuilder();
        bldr.setNominalEntries(16);
        bldr.setNumberOfValues(2);
        bldr.setResizeFactor(ResizeFactor.X1);
        double[] valuesArr1 = new double[]{1.0, 2.0};
        double[] valuesArr2 = new double[]{2.0, 4.0};
        ArrayOfDoublesUpdatableSketch sketch1 = bldr.build();
        sketch1.update("a", valuesArr1);
        sketch1.update("b", valuesArr2);
        sketch1.update("c", valuesArr1);
        sketch1.update("d", valuesArr1);
        ArrayOfDoublesUpdatableSketch sketch2 = bldr.build();
        sketch2.update("c", valuesArr2);
        sketch2.update("d", valuesArr2);
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketch1, (ArrayOfDoublesSketch)sketch2);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)2);
        double[] resultArr = new double[]{2.0, 4.0, 1.0, 2.0};
        Assert.assertEquals((double[])result.getValuesAsOneDimension(), (double[])resultArr);
    }

    @Test
    public void exactModeCustomSeed() {
        long seed = 1234567890L;
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        sketchA.update(1L, new double[]{1.0});
        sketchA.update(2L, new double[]{1.0});
        sketchA.update(3L, new double[]{1.0});
        sketchA.update(4L, new double[]{1.0});
        sketchA.update(5L, new double[]{1.0});
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(seed).build();
        sketchB.update(3L, new double[]{1.0});
        sketchB.update(4L, new double[]{1.0});
        sketchB.update(5L, new double[]{1.0});
        sketchB.update(6L, new double[]{1.0});
        sketchB.update(7L, new double[]{1.0});
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().setSeed(seed).buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((int)result.getRetainedEntries(), (int)2);
        Assert.assertEquals((double)result.getEstimate(), (double)2.0);
        Assert.assertEquals((double)result.getLowerBound(1), (double)2.0);
        Assert.assertEquals((double)result.getUpperBound(1), (double)2.0);
        ArrayOfDoublesSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
    }

    @Test
    public void estimationMode() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketchA.update((long)key++, new double[]{1.0});
        }
        key -= 4096;
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 8192; ++i) {
            sketchB.update((long)key++, new double[]{1.0});
        }
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        ArrayOfDoublesSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
        aNotB.update((ArrayOfDoublesSketch)sketchA.compact(), (ArrayOfDoublesSketch)sketchB.compact());
        result = aNotB.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)4096.0, (double)122.88);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
    }

    @Test
    public void estimationModeLargeB() {
        int key = 0;
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sketchA.update((long)key++, new double[]{1.0});
        }
        key -= 2000;
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().build();
        for (int i = 0; i < 100000; ++i) {
            sketchB.update((long)key++, new double[]{1.0});
        }
        int expected = 8000;
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
        ArrayOfDoublesCompactSketch result = aNotB.getResult();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)8000.0, (double)800.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        ArrayOfDoublesSketchIterator it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
        aNotB.update((ArrayOfDoublesSketch)sketchA.compact(), (ArrayOfDoublesSketch)sketchB.compact());
        result = aNotB.getResult(MemorySegment.ofArray(new byte[1000000]));
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((double)result.getEstimate(), (double)8000.0, (double)800.0);
        Assert.assertTrue((result.getLowerBound(1) <= result.getEstimate() ? 1 : 0) != 0);
        Assert.assertTrue((result.getUpperBound(1) > result.getEstimate() ? 1 : 0) != 0);
        it = result.iterator();
        while (it.next()) {
            Assert.assertEquals((double[])it.getValues(), (double[])new double[]{1.0});
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeedA() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketch, null);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeedB() {
        ArrayOfDoublesUpdatableSketch sketch = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().buildAnotB();
        aNotB.update(null, (ArrayOfDoublesSketch)sketch);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleSeeds() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(1L).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setSeed(2L).build();
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().setSeed(3L).buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void incompatibleNumValues() {
        ArrayOfDoublesUpdatableSketch sketchA = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(1).build();
        ArrayOfDoublesUpdatableSketch sketchB = new ArrayOfDoublesUpdatableSketchBuilder().setNumberOfValues(2).build();
        ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().setSeed(3L).buildAnotB();
        aNotB.update((ArrayOfDoublesSketch)sketchA, (ArrayOfDoublesSketch)sketchB);
    }
}

