/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import org.apache.directory.server.config.beans.AuthenticationInterceptorBean;
import org.apache.directory.server.config.beans.InterceptorBean;
import org.apache.directory.server.config.beans.PasswordPolicyBean;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPoliciesPage;
import org.apache.directory.studio.apacheds.configuration.editor.PasswordPolicyDetailsPage;
import org.apache.directory.studio.apacheds.configuration.editor.ServerConfigurationEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PasswordPoliciesMasterDetailsBlock
extends MasterDetailsBlock {
    private static final String NEW_ID = Messages.getString("PasswordPoliciesMasterDetailsBlock.PasswordPolicyNewId");
    private static final String AUTHENTICATION_INTERCEPTOR_ID = "authenticationInterceptor";
    private PasswordPoliciesPage page;
    private PasswordPolicyDetailsPage detailsPage;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;

    public PasswordPoliciesMasterDetailsBlock(PasswordPoliciesPage page) {
        this.page = page;
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
        this.sashForm.setWeights(new int[]{40, 60});
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("PasswordPoliciesMasterDetailsBlock.AllPasswordPolicies"));
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof PasswordPolicyBean) {
                    PasswordPolicyBean passwordPolicy = (PasswordPolicyBean)element;
                    if (passwordPolicy.isEnabled()) {
                        return NLS.bind((String)"{0} (enabled)", (Object)passwordPolicy.getPwdId());
                    }
                    return NLS.bind((String)"{0} (disabled)", (Object)passwordPolicy.getPwdId());
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof PasswordPolicyBean) {
                    PasswordPolicyBean passwordPolicy = (PasswordPolicyBean)element;
                    if (PasswordPoliciesPage.isDefaultPasswordPolicy(passwordPolicy)) {
                        return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/password_policy_default.gif");
                    }
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/password_policy.gif");
                }
                return super.getImage(element);
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PasswordPolicyBean && e2 instanceof PasswordPolicyBean) {
                    PasswordPolicyBean passwordPolicy1 = (PasswordPolicyBean)e1;
                    PasswordPolicyBean passwordPolicy2 = (PasswordPolicyBean)e2;
                    String passwordPolicy1Id = passwordPolicy1.getPwdId();
                    String passwordPolicy2Id = passwordPolicy2.getPwdId();
                    if (passwordPolicy1Id != null && passwordPolicy2Id != null) {
                        return passwordPolicy1Id.compareTo(passwordPolicy2Id);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.addButton = toolkit.createButton(client, Messages.getString("PasswordPoliciesMasterDetailsBlock.Add"), 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, Messages.getString("PasswordPoliciesMasterDetailsBlock.Delete"), 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    private void initFromInput() {
        AuthenticationInterceptorBean authenticationInterceptor = this.getAuthenticationInterceptor();
        if (authenticationInterceptor != null) {
            this.viewer.setInput((Object)authenticationInterceptor.getPasswordPolicies());
        } else {
            this.viewer.setInput(null);
        }
    }

    public void refreshUI() {
        this.initFromInput();
        this.viewer.refresh();
    }

    private AuthenticationInterceptorBean getAuthenticationInterceptor() {
        for (InterceptorBean interceptor : this.page.getConfigBean().getDirectoryServiceBean().getInterceptors()) {
            if (!AUTHENTICATION_INTERCEPTOR_ID.equalsIgnoreCase(interceptor.getInterceptorId()) || !(interceptor instanceof AuthenticationInterceptorBean)) continue;
            return (AuthenticationInterceptorBean)interceptor;
        }
        return null;
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PasswordPolicyBean passwordPolicy;
                PasswordPoliciesMasterDetailsBlock.this.viewer.refresh();
                StructuredSelection selection = (StructuredSelection)PasswordPoliciesMasterDetailsBlock.this.viewer.getSelection();
                PasswordPoliciesMasterDetailsBlock.this.deleteButton.setEnabled(!selection.isEmpty());
                if (!selection.isEmpty() && PasswordPoliciesPage.isDefaultPasswordPolicy(passwordPolicy = (PasswordPolicyBean)selection.getFirstElement())) {
                    PasswordPoliciesMasterDetailsBlock.this.deleteButton.setEnabled(false);
                }
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordPoliciesMasterDetailsBlock.this.addNewPasswordPolicy();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordPoliciesMasterDetailsBlock.this.deleteSelectedPasswordPolicy();
            }
        });
    }

    private void addNewPasswordPolicy() {
        String newId = this.getNewId();
        PasswordPolicyBean newPasswordPolicy = new PasswordPolicyBean();
        newPasswordPolicy.setPwdId(newId);
        newPasswordPolicy.setPwdMaxAge(0);
        newPasswordPolicy.setPwdFailureCountInterval(30);
        newPasswordPolicy.setPwdAttribute("userPassword");
        newPasswordPolicy.setPwdMaxFailure(5);
        newPasswordPolicy.setPwdLockout(true);
        newPasswordPolicy.setPwdMustChange(false);
        newPasswordPolicy.setPwdLockoutDuration(0);
        newPasswordPolicy.setPwdMinLength(5);
        newPasswordPolicy.setPwdInHistory(5);
        newPasswordPolicy.setPwdExpireWarning(600);
        newPasswordPolicy.setPwdMinAge(0);
        newPasswordPolicy.setPwdAllowUserChange(true);
        newPasswordPolicy.setPwdGraceAuthNLimit(5);
        newPasswordPolicy.setPwdCheckQuality(1);
        newPasswordPolicy.setPwdMaxLength(0);
        newPasswordPolicy.setPwdGraceExpire(0);
        newPasswordPolicy.setPwdMinDelay(0);
        newPasswordPolicy.setPwdMaxDelay(0);
        newPasswordPolicy.setPwdMaxIdle(0);
        this.getAuthenticationInterceptor().addPasswordPolicies(new PasswordPolicyBean[]{newPasswordPolicy});
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newPasswordPolicy));
        this.setEditorDirty();
    }

    private String getNewId() {
        int counter = 1;
        String name = NEW_ID;
        boolean ok = false;
        while (!ok) {
            ok = true;
            name = String.valueOf(NEW_ID) + counter;
            for (PasswordPolicyBean passwordPolicy : this.getAuthenticationInterceptor().getPasswordPolicies()) {
                if (!passwordPolicy.getPwdId().equalsIgnoreCase(name)) continue;
                ok = false;
            }
            ++counter;
        }
        return name;
    }

    private void deleteSelectedPasswordPolicy() {
        PasswordPolicyBean passwordPolicy;
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && !PasswordPoliciesPage.isDefaultPasswordPolicy(passwordPolicy = (PasswordPolicyBean)selection.getFirstElement()) && MessageDialog.openConfirm((Shell)this.page.getManagedForm().getForm().getShell(), (String)Messages.getString("PasswordPoliciesMasterDetailsBlock.ConfirmDelete"), (String)NLS.bind((String)Messages.getString("PasswordPoliciesMasterDetailsBlock.AreYouSureDeletePasswordPolicy"), (Object)passwordPolicy.getPwdId()))) {
            this.getAuthenticationInterceptor().removePasswordPolicies(new PasswordPolicyBean[]{passwordPolicy});
            this.setEditorDirty();
        }
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new PasswordPolicyDetailsPage(this);
        detailsPart.registerPage(PasswordPolicyBean.class, (IDetailsPage)this.detailsPage);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
        this.viewer.refresh();
    }

    public void save() {
        this.detailsPage.commit(true);
    }
}

