/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.loanaccount.api.LoansApiResource;
import org.springframework.stereotype.Component;

@Component
public class LoanStateTransistionsByExternalIdCommandStrategy
implements CommandStrategy {
    private final LoansApiResource loansApiResource;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request);
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        String loanExternalIdPathParameter = (String)pathParameters.get(2);
        Pattern commandPattern = Pattern.compile("^?command=[a-zA-Z]+");
        Matcher commandMatcher = commandPattern.matcher(loanExternalIdPathParameter);
        if (!commandMatcher.find()) {
            response.setRequestId(request.getRequestId());
            response.setStatusCode(Integer.valueOf(501));
            response.setBody("Resource with method " + request.getMethod() + " and relativeUrl " + request.getRelativeUrl() + " doesn't exist");
            return response;
        }
        String commandQueryParam = commandMatcher.group(0);
        String command = commandQueryParam.substring(commandQueryParam.indexOf("=") + 1);
        String loanExternalId = StringUtils.substringBefore((String)loanExternalIdPathParameter, (String)"?");
        String responseBody = this.loansApiResource.stateTransitions(loanExternalId, command, request.getBody());
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(responseBody);
        return response;
    }

    @Generated
    public LoanStateTransistionsByExternalIdCommandStrategy(LoansApiResource loansApiResource) {
        this.loansApiResource = loansApiResource;
    }
}

