/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.accountnumberformat.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.accountnumberformat.api.AccountNumberFormatsApiResourceSwagger;
import org.apache.fineract.infrastructure.accountnumberformat.data.AccountNumberFormatData;
import org.apache.fineract.infrastructure.accountnumberformat.domain.EntityAccountType;
import org.apache.fineract.infrastructure.accountnumberformat.service.AccountNumberFormatReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/accountnumberformats")
@Component
@Tag(name="Account number format", description="Account number preferences are used to describe custom formats for account numbers associated with Customer, Loan and Savings accounts.")
public class AccountNumberFormatsApiResource {
    private final PlatformSecurityContext context;
    private final AccountNumberFormatReadPlatformService accountNumberFormatReadPlatformService;
    private final ToApiJsonSerializer<AccountNumberFormatData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private static final Set<String> ACCOUNT_NUMBER_FORMAT_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "accountType", "prefixType", "accountTypeOptions", "prefixTypeOptions"));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Account number format Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\n\nExample Request:\n\naccountnumberformats/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.GetAccountNumberFormatsResponseTemplate.class))})})
    public String retrieveTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("accountNumberFormat");
        EntityAccountType accountType = null;
        AccountNumberFormatData accountNumberFormatData = this.accountNumberFormatReadPlatformService.retrieveTemplate(accountType);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)accountNumberFormatData, ACCOUNT_NUMBER_FORMAT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Account number formats", description="Example Requests:\n\naccountnumberformats\n\n\naccountnumberformats?fields=accountType,prefixType")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.GetAccountNumberFormatsIdResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("accountNumberFormat");
        List accountNumberFormatData = this.accountNumberFormatReadPlatformService.getAllAccountNumberFormats();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Collection)accountNumberFormatData, ACCOUNT_NUMBER_FORMAT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{accountNumberFormatId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve an Account number format", description="Example Requests:\n\naccountnumberformats/1\n\n\naccountnumberformats/1?template=true\n\n\naccountnumberformats/1?fields=accountType,prefixType")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.GetAccountNumberFormatsIdResponse.class))})})
    public String retrieveOne(@Context UriInfo uriInfo, @PathParam(value="accountNumberFormatId") @Parameter(description="accountNumberFormatId") Long accountNumberFormatId) {
        this.context.authenticatedUser().validateHasReadPermission("accountNumberFormat");
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        AccountNumberFormatData accountNumberFormatData = this.accountNumberFormatReadPlatformService.getAccountNumberFormat(accountNumberFormatId);
        if (settings.isTemplate()) {
            AccountNumberFormatData templateData = this.accountNumberFormatReadPlatformService.retrieveTemplate(EntityAccountType.fromInt((int)((Long)accountNumberFormatData.getAccountType().getId()).intValue()));
            accountNumberFormatData.templateOnTop(templateData.getAccountTypeOptions(), templateData.getPrefixTypeOptions());
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)accountNumberFormatData, ACCOUNT_NUMBER_FORMAT_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an Account number format", description="Note: You may associate a single Account number format for a given account type\nMandatory Fields for Account number formats\naccountType")
    @RequestBody(content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.PostAccountNumberFormatsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.PostAccountNumberFormatsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createAccountNumberFormat().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{accountNumberFormatId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update an Account number format")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.PutAccountNumberFormatsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.PutAccountNumberFormatsResponse.class))})})
    public String update(@PathParam(value="accountNumberFormatId") @Parameter(description="accountNumberFormatId") Long accountNumberFormatId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateAccountNumberFormat(accountNumberFormatId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{accountNumberFormatId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete an Account number format", description="Note: Account numbers created while this format was active would remain unchanged.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=AccountNumberFormatsApiResourceSwagger.DeleteAccountNumberFormatsResponse.class))})})
    public String delete(@PathParam(value="accountNumberFormatId") @Parameter(description="accountNumberFormatId") Long accountNumberFormatId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteAccountNumberFormat(accountNumberFormatId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public AccountNumberFormatsApiResource(PlatformSecurityContext context, AccountNumberFormatReadPlatformService accountNumberFormatReadPlatformService, ToApiJsonSerializer<AccountNumberFormatData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.accountNumberFormatReadPlatformService = accountNumberFormatReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

