/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.entityaccess.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.entityaccess.api.FineractEntityApiResourceConstants;
import org.apache.fineract.infrastructure.entityaccess.data.FineractEntityRelationData;
import org.apache.fineract.infrastructure.entityaccess.data.FineractEntityToEntityMappingData;
import org.apache.fineract.infrastructure.entityaccess.service.FineractEntityAccessReadService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.stereotype.Component;

@Path(value="/v1/entitytoentitymapping")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@Tag(name="Fineract Entity", description="")
public class FineractEntityApiResource {
    private final PlatformSecurityContext context;
    private final FineractEntityAccessReadService readPlatformService;
    private final DefaultToApiJsonSerializer<FineractEntityRelationData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<FineractEntityToEntityMappingData> toApiJsonSerializerOfficeToLoanProducts;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("FineractEntity");
        Collection entityMappings = this.readPlatformService.retrieveAllSupportedMappingTypes();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, entityMappings, FineractEntityApiResourceConstants.RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/{mapId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveOne(@PathParam(value="mapId") Long mapId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("FineractEntity");
        Collection entityToEntityMappings = this.readPlatformService.retrieveOneMapping(mapId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerOfficeToLoanProducts.serialize(settings, entityToEntityMappings, FineractEntityApiResourceConstants.FETCH_ENTITY_TO_ENTITY_MAPPINGS);
    }

    @GET
    @Path(value="/{mapId}/{fromId}/{toId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getEntityToEntityMappings(@PathParam(value="mapId") Long mapId, @PathParam(value="fromId") Long fromId, @PathParam(value="toId") Long toId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("FineractEntity");
        Collection entityToEntityMappings = this.readPlatformService.retrieveEntityToEntityMappings(mapId, fromId, toId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializerOfficeToLoanProducts.serialize(settings, entityToEntityMappings, FineractEntityApiResourceConstants.FETCH_ENTITY_TO_ENTITY_MAPPINGS);
    }

    @POST
    @Path(value="/{relId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String createMap(@PathParam(value="relId") Long relId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createMap(relId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="/{mapId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateMap(@PathParam(value="mapId") Long mapId, String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateMap(mapId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{mapId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String delete(@PathParam(value="mapId") Long mapId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteMap(mapId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public FineractEntityApiResource(PlatformSecurityContext context, FineractEntityAccessReadService readPlatformService, DefaultToApiJsonSerializer<FineractEntityRelationData> toApiJsonSerializer, DefaultToApiJsonSerializer<FineractEntityToEntityMappingData> toApiJsonSerializerOfficeToLoanProducts, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.toApiJsonSerializerOfficeToLoanProducts = toApiJsonSerializerOfficeToLoanProducts;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

