/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.api.StaffApiResourceSwagger;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.data.StaffRequest;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;

@Path(value="/v1/staff")
@Component
@Tag(name="Staff", description="Allows you to model staff members. At present the key role of significance is whether this staff member is a loan officer or not.")
public class StaffApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "STAFF";
    private final PlatformSecurityContext context;
    private final StaffReadPlatformService readPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final DefaultToApiJsonSerializer<StaffData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Staff", description="Returns the list of staff members.\n\nExample Requests:\n\nstaff\n\n\n\n\nRetrieve a Staff by status\n\nReturns the details of a Staff based on status.\n\nBy default it Returns all the ACTIVE Staff.\n\nIf status=INACTIVE, then it returns all INACTIVE Staff.\n\nand for status=ALL, it Returns both ACTIVE and INACTIVE Staff.\n\nExample Requests:\n\nstaff?status=active")
    public List<StaffData> retrieveAll(@QueryParam(value="officeId") @Parameter(description="officeId") Long officeId, @DefaultValue(value="false") @QueryParam(value="staffInOfficeHierarchy") @Parameter(description="staffInOfficeHierarchy") boolean staffInOfficeHierarchy, @DefaultValue(value="false") @QueryParam(value="loanOfficersOnly") @Parameter(description="loanOfficersOnly") boolean loanOfficersOnly, @DefaultValue(value="active") @QueryParam(value="status") @Parameter(description="status") String status) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        return staffInOfficeHierarchy ? this.readPlatformService.retrieveAllStaffInOfficeAndItsParentOfficeHierarchy(officeId, loanOfficersOnly) : this.readPlatformService.retrieveAllStaff(officeId, loanOfficersOnly, status);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a staff member", description="Creates a staff member.\n\nMandatory Fields: \nofficeId, firstname, lastname\n\nOptional Fields: \nisLoanOfficer, isActive")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=StaffRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StaffApiResourceSwagger.CreateStaffResponse.class))})})
    public CommandProcessingResult create(@Parameter(hidden=true) StaffRequest staffRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createStaff().withJson(this.toApiJsonSerializer.serialize((Object)staffRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="{staffId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Staff Member", description="Returns the details of a Staff Member.\n\nExample Requests:\n\nstaff/1")
    public StaffData retrieveOne(@PathParam(value="staffId") @Parameter(description="staffId") Long staffId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        StaffData staff = this.readPlatformService.retrieveStaff(staffId);
        if (settings.isTemplate()) {
            Collection allowedOffices = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            staff = StaffData.templateData((StaffData)staff, (Collection)allowedOffices);
        }
        return staff;
    }

    @PUT
    @Path(value="{staffId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Staff Member", description="Updates the details of a staff member.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=StaffApiResourceSwagger.PutStaffRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StaffApiResourceSwagger.UpdateStaffResponse.class))})})
    public CommandProcessingResult update(@PathParam(value="staffId") @Parameter(description="staffId") Long staffId, @Parameter(hidden=true) StaffRequest staffRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateStaff(staffId).withJson(this.toApiJsonSerializer.serialize((Object)staffRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.STAFF.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload staff template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public Long postTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.STAFF.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
    }

    @Generated
    public StaffApiResource(PlatformSecurityContext context, StaffReadPlatformService readPlatformService, OfficeReadPlatformService officeReadPlatformService, DefaultToApiJsonSerializer<StaffData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService) {
        this.context = context;
        this.readPlatformService = readPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
    }
}

