/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.workingdays.service;

import java.text.ParseException;
import java.util.Map;
import lombok.Generated;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.validate.ValidationException;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.organisation.workingdays.data.WorkingDayValidator;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysWritePlatformService;
import org.springframework.transaction.annotation.Transactional;

public class WorkingDaysWritePlatformServiceJpaRepositoryImpl
implements WorkingDaysWritePlatformService {
    private final WorkingDaysRepositoryWrapper daysRepositoryWrapper;
    private final WorkingDayValidator fromApiJsonDeserializer;

    @Transactional
    public CommandProcessingResult updateWorkingDays(JsonCommand command) {
        String recurrence = "";
        RRule rrule = null;
        try {
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            WorkingDays workingDays = this.daysRepositoryWrapper.findOne();
            recurrence = command.stringValueOfParameterNamed("recurrence");
            rrule = new RRule(recurrence);
            rrule.validate();
            Map changes = workingDays.update(command);
            this.daysRepositoryWrapper.saveAndFlush(workingDays);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)workingDays.getId()).with(changes).build();
        }
        catch (ValidationException e) {
            throw new PlatformDataIntegrityException("error.msg.invalid.recurring.rule", "The Recurring Rule value: " + recurrence + " is not valid.", "recurrence", new Object[]{recurrence, e});
        }
        catch (IllegalArgumentException | ParseException e) {
            throw new PlatformDataIntegrityException("error.msg.recurring.rule.parsing.error", "Error in passing the Recurring Rule value: " + recurrence, "recurrence", new Object[]{e.getMessage(), e});
        }
    }

    @Generated
    public WorkingDaysWritePlatformServiceJpaRepositoryImpl(WorkingDaysRepositoryWrapper daysRepositoryWrapper, WorkingDayValidator fromApiJsonDeserializer) {
        this.daysRepositoryWrapper = daysRepositoryWrapper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
    }
}

