/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.domain.OrganisationCurrency;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeCalculationType;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientCharge;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_client_charge")
public class ClientCharge
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @ManyToOne(optional=false)
    @JoinColumn(name="client_id", referencedColumnName="id", nullable=false)
    private Client client;
    @ManyToOne(optional=false)
    @JoinColumn(name="charge_id", referencedColumnName="id", nullable=false)
    private Charge charge;
    @Column(name="charge_time_enum", nullable=false)
    private Integer chargeTime;
    @Column(name="charge_due_date")
    private LocalDate dueDate;
    @Column(name="charge_calculation_enum")
    private Integer chargeCalculation;
    @Column(name="amount", scale=6, precision=19, nullable=false)
    private BigDecimal amount;
    @Column(name="amount_paid_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountPaid;
    @Column(name="amount_waived_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountWaived;
    @Column(name="amount_writtenoff_derived", scale=6, precision=19, nullable=true)
    private BigDecimal amountWrittenOff;
    @Column(name="amount_outstanding_derived", scale=6, precision=19, nullable=false)
    private BigDecimal amountOutstanding;
    @Column(name="is_penalty", nullable=false)
    private boolean penaltyCharge = false;
    @Column(name="is_paid_derived", nullable=false)
    private boolean paid = false;
    @Column(name="waived", nullable=false)
    private boolean waived = false;
    @Column(name="is_active", nullable=false)
    private boolean status = true;
    @Column(name="inactivated_on_date")
    private LocalDate inactivationDate;
    @Transient
    private OrganisationCurrency currency;
    static final long serialVersionUID = 3431723068089051757L;

    protected ClientCharge() {
    }

    public static ClientCharge createNew(Client client, Charge charge, JsonCommand command) {
        BigDecimal amount = command.bigDecimalValueOfParameterNamed("amount");
        LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
        boolean status = true;
        amount = amount == null ? charge.getAmount() : amount;
        return new ClientCharge(client, charge, amount, dueDate, true);
    }

    private ClientCharge(Client client, Charge charge, BigDecimal amount, LocalDate dueDate, boolean status) {
        this.client = client;
        this.charge = charge;
        this.penaltyCharge = charge.isPenalty();
        this.chargeTime = charge.getChargeTimeType();
        this.dueDate = dueDate;
        this.chargeCalculation = charge.getChargeCalculation();
        BigDecimal chargeAmount = charge.getAmount();
        if (amount != null) {
            chargeAmount = amount;
        }
        this.populateDerivedFields(chargeAmount);
        this.paid = this.determineIfFullyPaid();
        this.status = status;
    }

    public Money pay(Money amountPaid) {
        Money amountPaidToDate = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountPaid());
        Money amountOutstanding = Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountOutstanding());
        amountPaidToDate = amountPaidToDate.plus(amountPaid);
        amountOutstanding = amountOutstanding.minus(amountPaid);
        this._persistence_set_amountPaid(amountPaidToDate.getAmount());
        this._persistence_set_amountOutstanding(amountOutstanding.getAmount());
        this._persistence_set_paid(this.determineIfFullyPaid());
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountOutstanding());
    }

    public void undoPayment(Money transactionAmount) {
        Money amountPaid = this.getAmountPaid();
        amountPaid = amountPaid.minus(transactionAmount);
        this._persistence_set_amountPaid(amountPaid.getAmount());
        this._persistence_set_amountOutstanding(this.calculateOutstanding());
        this._persistence_set_paid(false);
        this._persistence_set_status(true);
    }

    public Money waive() {
        Money amountWaivedToDate = this.getAmountWaived();
        Money amountOutstanding = this.getAmountOutstanding();
        Money totalAmountWaived = amountWaivedToDate.plus(amountOutstanding);
        this._persistence_set_amountWaived(totalAmountWaived.getAmount());
        this._persistence_set_amountOutstanding(BigDecimal.ZERO);
        this._persistence_set_waived(true);
        return totalAmountWaived;
    }

    public void undoWaiver(Money transactionAmount) {
        Money amountWaived = this.getAmountWaived();
        amountWaived = amountWaived.minus(transactionAmount);
        this._persistence_set_amountWaived(amountWaived.getAmount());
        this._persistence_set_amountOutstanding(this.calculateOutstanding());
        this._persistence_set_waived(false);
        this._persistence_set_status(true);
    }

    private void populateDerivedFields(BigDecimal amount) {
        switch (1.$SwitchMap$org$apache$fineract$portfolio$charge$domain$ChargeCalculationType[ChargeCalculationType.fromInt((Integer)this._persistence_get_chargeCalculation()).ordinal()]) {
            case 1: {
                this._persistence_set_amount(null);
                this._persistence_set_amountPaid(null);
                this._persistence_set_amountOutstanding(BigDecimal.ZERO);
                this._persistence_set_amountWaived(null);
                this._persistence_set_amountWrittenOff(null);
                break;
            }
            case 2: {
                this._persistence_set_amount(amount);
                this._persistence_set_amountPaid(null);
                this._persistence_set_amountOutstanding(amount);
                this._persistence_set_amountWaived(null);
                this._persistence_set_amountWrittenOff(null);
                break;
            }
        }
    }

    public boolean isOnSpecifiedDueDate() {
        return ChargeTimeType.fromInt((Integer)this._persistence_get_chargeTime()).isOnSpecifiedDueDate();
    }

    private boolean determineIfFullyPaid() {
        return BigDecimal.ZERO.compareTo(this.calculateOutstanding()) == 0;
    }

    private BigDecimal calculateOutstanding() {
        BigDecimal amountPaidLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountPaid() != null) {
            amountPaidLocal = this._persistence_get_amountPaid();
        }
        BigDecimal amountWaivedLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountWaived() != null) {
            amountWaivedLocal = this._persistence_get_amountWaived();
        }
        BigDecimal amountWrittenOffLocal = BigDecimal.ZERO;
        if (this._persistence_get_amountWrittenOff() != null) {
            amountWrittenOffLocal = this._persistence_get_amountWrittenOff();
        }
        BigDecimal totalAccountedFor = amountPaidLocal.add(amountWaivedLocal).add(amountWrittenOffLocal);
        return this._persistence_get_amount().subtract(totalAccountedFor);
    }

    public LocalDate getDueLocalDate() {
        return this._persistence_get_dueDate();
    }

    public Client getClient() {
        return this._persistence_get_client();
    }

    public Charge getCharge() {
        return this._persistence_get_charge();
    }

    public Integer getChargeTime() {
        return this._persistence_get_chargeTime();
    }

    public LocalDate getDueDate() {
        return this._persistence_get_dueDate();
    }

    public Integer getChargeCalculation() {
        return this._persistence_get_chargeCalculation();
    }

    public boolean isPenaltyCharge() {
        return this._persistence_get_penaltyCharge();
    }

    public boolean isPaid() {
        return this._persistence_get_paid();
    }

    public boolean isWaived() {
        return this._persistence_get_waived();
    }

    public boolean isActive() {
        return this._persistence_get_status();
    }

    public boolean isNotActive() {
        return !this._persistence_get_status();
    }

    public LocalDate getInactivationDate() {
        return this._persistence_get_inactivationDate();
    }

    public Long getClientId() {
        return (Long)this._persistence_get_client().getId();
    }

    public Long getOfficeId() {
        return (Long)this._persistence_get_client().getOffice().getId();
    }

    public void setCurrency(OrganisationCurrency currency) {
        this.currency = currency;
    }

    public MonetaryCurrency getCurrency() {
        return this.currency.toMonetaryCurrency();
    }

    public boolean isPaidOrPartiallyPaid(MonetaryCurrency currency) {
        Money amountWaivedOrWrittenOff = this.getAmountWaived().plus(this.getAmountWrittenOff());
        return Money.of((MonetaryCurrency)currency, (BigDecimal)this._persistence_get_amountPaid()).plus(amountWaivedOrWrittenOff).isGreaterThanZero();
    }

    public Money getAmount() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amount());
    }

    public Money getAmountPaid() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountPaid());
    }

    public Money getAmountWaived() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountWaived());
    }

    public Money getAmountWrittenOff() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountWrittenOff());
    }

    public Money getAmountOutstanding() {
        return Money.of((MonetaryCurrency)this.getCurrency(), (BigDecimal)this._persistence_get_amountOutstanding());
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ClientCharge();
    }

    public Object _persistence_get(String string) {
        if (string == "amount") {
            return this.amount;
        }
        if (string == "charge") {
            return this.charge;
        }
        if (string == "amountOutstanding") {
            return this.amountOutstanding;
        }
        if (string == "chargeTime") {
            return this.chargeTime;
        }
        if (string == "dueDate") {
            return this.dueDate;
        }
        if (string == "penaltyCharge") {
            return this.penaltyCharge;
        }
        if (string == "chargeCalculation") {
            return this.chargeCalculation;
        }
        if (string == "amountWaived") {
            return this.amountWaived;
        }
        if (string == "waived") {
            return this.waived;
        }
        if (string == "amountPaid") {
            return this.amountPaid;
        }
        if (string == "amountWrittenOff") {
            return this.amountWrittenOff;
        }
        if (string == "paid") {
            return this.paid;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "inactivationDate") {
            return this.inactivationDate;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "amount") {
            this.amount = (BigDecimal)object;
            return;
        }
        if (string == "charge") {
            this.charge = (Charge)object;
            return;
        }
        if (string == "amountOutstanding") {
            this.amountOutstanding = (BigDecimal)object;
            return;
        }
        if (string == "chargeTime") {
            this.chargeTime = (Integer)object;
            return;
        }
        if (string == "dueDate") {
            this.dueDate = (LocalDate)object;
            return;
        }
        if (string == "penaltyCharge") {
            this.penaltyCharge = (Boolean)object;
            return;
        }
        if (string == "chargeCalculation") {
            this.chargeCalculation = (Integer)object;
            return;
        }
        if (string == "amountWaived") {
            this.amountWaived = (BigDecimal)object;
            return;
        }
        if (string == "waived") {
            this.waived = (Boolean)object;
            return;
        }
        if (string == "amountPaid") {
            this.amountPaid = (BigDecimal)object;
            return;
        }
        if (string == "amountWrittenOff") {
            this.amountWrittenOff = (BigDecimal)object;
            return;
        }
        if (string == "paid") {
            this.paid = (Boolean)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "inactivationDate") {
            this.inactivationDate = (LocalDate)object;
            return;
        }
        if (string == "status") {
            this.status = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public BigDecimal _persistence_get_amount() {
        this._persistence_checkFetched("amount");
        return this.amount;
    }

    public void _persistence_set_amount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amount");
        this._persistence_propertyChange("amount", (Object)this.amount, (Object)bigDecimal);
        this.amount = bigDecimal;
    }

    public Charge _persistence_get_charge() {
        this._persistence_checkFetched("charge");
        return this.charge;
    }

    public void _persistence_set_charge(Charge charge) {
        this._persistence_checkFetchedForSet("charge");
        this._persistence_propertyChange("charge", (Object)this.charge, (Object)charge);
        this.charge = charge;
    }

    public BigDecimal _persistence_get_amountOutstanding() {
        this._persistence_checkFetched("amountOutstanding");
        return this.amountOutstanding;
    }

    public void _persistence_set_amountOutstanding(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountOutstanding");
        this._persistence_propertyChange("amountOutstanding", (Object)this.amountOutstanding, (Object)bigDecimal);
        this.amountOutstanding = bigDecimal;
    }

    public Integer _persistence_get_chargeTime() {
        this._persistence_checkFetched("chargeTime");
        return this.chargeTime;
    }

    public void _persistence_set_chargeTime(Integer n) {
        this._persistence_checkFetchedForSet("chargeTime");
        this._persistence_propertyChange("chargeTime", (Object)this.chargeTime, (Object)n);
        this.chargeTime = n;
    }

    public LocalDate _persistence_get_dueDate() {
        this._persistence_checkFetched("dueDate");
        return this.dueDate;
    }

    public void _persistence_set_dueDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("dueDate");
        this._persistence_propertyChange("dueDate", (Object)this.dueDate, (Object)localDate);
        this.dueDate = localDate;
    }

    public boolean _persistence_get_penaltyCharge() {
        this._persistence_checkFetched("penaltyCharge");
        return this.penaltyCharge;
    }

    public void _persistence_set_penaltyCharge(boolean bl) {
        this._persistence_checkFetchedForSet("penaltyCharge");
        this._persistence_propertyChange("penaltyCharge", (Object)new Boolean(this.penaltyCharge), (Object)new Boolean(bl));
        this.penaltyCharge = bl;
    }

    public Integer _persistence_get_chargeCalculation() {
        this._persistence_checkFetched("chargeCalculation");
        return this.chargeCalculation;
    }

    public void _persistence_set_chargeCalculation(Integer n) {
        this._persistence_checkFetchedForSet("chargeCalculation");
        this._persistence_propertyChange("chargeCalculation", (Object)this.chargeCalculation, (Object)n);
        this.chargeCalculation = n;
    }

    public BigDecimal _persistence_get_amountWaived() {
        this._persistence_checkFetched("amountWaived");
        return this.amountWaived;
    }

    public void _persistence_set_amountWaived(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountWaived");
        this._persistence_propertyChange("amountWaived", (Object)this.amountWaived, (Object)bigDecimal);
        this.amountWaived = bigDecimal;
    }

    public boolean _persistence_get_waived() {
        this._persistence_checkFetched("waived");
        return this.waived;
    }

    public void _persistence_set_waived(boolean bl) {
        this._persistence_checkFetchedForSet("waived");
        this._persistence_propertyChange("waived", (Object)new Boolean(this.waived), (Object)new Boolean(bl));
        this.waived = bl;
    }

    public BigDecimal _persistence_get_amountPaid() {
        this._persistence_checkFetched("amountPaid");
        return this.amountPaid;
    }

    public void _persistence_set_amountPaid(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountPaid");
        this._persistence_propertyChange("amountPaid", (Object)this.amountPaid, (Object)bigDecimal);
        this.amountPaid = bigDecimal;
    }

    public BigDecimal _persistence_get_amountWrittenOff() {
        this._persistence_checkFetched("amountWrittenOff");
        return this.amountWrittenOff;
    }

    public void _persistence_set_amountWrittenOff(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("amountWrittenOff");
        this._persistence_propertyChange("amountWrittenOff", (Object)this.amountWrittenOff, (Object)bigDecimal);
        this.amountWrittenOff = bigDecimal;
    }

    public boolean _persistence_get_paid() {
        this._persistence_checkFetched("paid");
        return this.paid;
    }

    public void _persistence_set_paid(boolean bl) {
        this._persistence_checkFetchedForSet("paid");
        this._persistence_propertyChange("paid", (Object)new Boolean(this.paid), (Object)new Boolean(bl));
        this.paid = bl;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public LocalDate _persistence_get_inactivationDate() {
        this._persistence_checkFetched("inactivationDate");
        return this.inactivationDate;
    }

    public void _persistence_set_inactivationDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("inactivationDate");
        this._persistence_propertyChange("inactivationDate", (Object)this.inactivationDate, (Object)localDate);
        this.inactivationDate = localDate;
    }

    public boolean _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(boolean bl) {
        this._persistence_checkFetchedForSet("status");
        this._persistence_propertyChange("status", (Object)new Boolean(this.status), (Object)new Boolean(bl));
        this.status = bl;
    }
}

