/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.group.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupRolesDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> GROUP_ROLES_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("role", "clientId"));

    @Autowired
    public GroupRolesDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForCreateGroupRole(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_ROLES_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("grouprole");
        JsonElement element = command.parsedJson();
        Long roleId = this.fromApiJsonHelper.extractLongNamed("role", element);
        baseDataValidator.reset().parameter("role").value((Object)roleId).notNull().longGreaterThanZero();
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        baseDataValidator.reset().parameter("clientId").value((Object)clientId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdateRole(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)GROUP_ROLES_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("grouprole");
        JsonElement element = command.parsedJson();
        Long roleId = this.fromApiJsonHelper.extractLongNamed("role", element);
        baseDataValidator.reset().parameter("role").value((Object)roleId).ignoreIfNull().notBlank().longGreaterThanZero();
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        baseDataValidator.reset().parameter("clientId").value((Object)clientId).ignoreIfNull().notBlank().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

