/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanOfficerAssignmentHistory;
import org.apache.fineract.portfolio.loanaccount.exception.LoanOfficerAssignmentException;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanOfficerValidator;

public class LoanOfficerService {
    private final LoanOfficerValidator loanOfficerValidator;

    public void reassignLoanOfficer(Loan loan, Staff newLoanOfficer, LocalDate assignmentDate) {
        Optional latestHistoryRecord = loan.findLatestIncompleteHistoryRecord();
        LoanOfficerAssignmentHistory lastAssignmentRecord = loan.findLastAssignmentHistoryRecord(newLoanOfficer);
        this.loanOfficerValidator.validateReassignment(loan, assignmentDate, lastAssignmentRecord);
        this.loanOfficerValidator.validateAssignmentDateWithHistory(loan, latestHistoryRecord, assignmentDate);
        if (latestHistoryRecord.isPresent() && loan.getLoanOfficer().identifiedBy(newLoanOfficer)) {
            ((LoanOfficerAssignmentHistory)latestHistoryRecord.get()).updateStartDate(assignmentDate);
        } else if (latestHistoryRecord.isPresent() && ((LoanOfficerAssignmentHistory)latestHistoryRecord.get()).matchesStartDateOf(assignmentDate)) {
            ((LoanOfficerAssignmentHistory)latestHistoryRecord.get()).updateLoanOfficer(newLoanOfficer);
            loan.setLoanOfficer(newLoanOfficer);
        } else {
            latestHistoryRecord.ifPresent(loanOfficerAssignmentHistory -> loanOfficerAssignmentHistory.updateEndDate(assignmentDate));
            loan.setLoanOfficer(newLoanOfficer);
            if (loan.isNotSubmittedAndPendingApproval()) {
                LoanOfficerAssignmentHistory loanOfficerAssignmentHistory2 = LoanOfficerAssignmentHistory.createNew((Loan)loan, (Staff)loan.getLoanOfficer(), (LocalDate)assignmentDate);
                loan.getLoanOfficerHistory().add(loanOfficerAssignmentHistory2);
            }
        }
    }

    public void updateLoanOfficerOnLoanApplication(Loan loan, Staff newLoanOfficer) {
        if (!loan.isSubmittedAndPendingApproval()) {
            Long loanOfficerId = null;
            if (loan.getLoanOfficer() != null) {
                loanOfficerId = (Long)loan.getLoanOfficer().getId();
            }
            throw new LoanOfficerAssignmentException((Long)loan.getId(), loanOfficerId);
        }
        loan.setLoanOfficer(newLoanOfficer);
    }

    @Generated
    public LoanOfficerService(LoanOfficerValidator loanOfficerValidator) {
        this.loanOfficerValidator = loanOfficerValidator;
    }
}

