/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reamortization;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepository;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reamortization.LoanReAmortizeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reamortization.LoanUndoReAmortizeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reamortization.LoanReAmortizeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reamortization.LoanUndoReAmortizeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.loanaccount.api.request.ReAmortizationPreviewRequest;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.reamortization.LoanReAmortizationInterestHandlingType;
import org.apache.fineract.portfolio.loanaccount.domain.reamortization.LoanReAmortizationParameter;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanRepaymentScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.reamortization.LoanReAmortizationValidator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanReAmortizationService {
    private final LoanAssembler loanAssembler;
    private final LoanReAmortizationValidator reAmortizationValidator;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanChargeValidator loanChargeValidator;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final CodeValueRepository codeValueRepository;
    private final LoanScheduleService loanScheduleService;
    private final LoanRepaymentScheduleService loanRepaymentScheduleService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;

    public CommandProcessingResult reAmortize(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAmortizationValidator.validateReAmortize(loan, command);
        LoanTransaction reAmortizeTransaction = this.createReAmortizeTransaction(loan, command);
        reAmortizeTransaction.setLoanReAmortizationParameter(this.createReAmortizationParameter(reAmortizeTransaction, command));
        this.processReAmortizationTransaction(loan, reAmortizeTransaction, true);
        this.loanTransactionRepository.saveAndFlush((Object)reAmortizeTransaction);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAmortizeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAmortizeTransactionBusinessEvent(reAmortizeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAmortizeTransaction.getId()).withEntityExternalId(reAmortizeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    public CommandProcessingResult undoReAmortize(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAmortizationValidator.validateUndoReAmortize(loan, command);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LoanTransaction reAmortizeTransaction = this.findLatestNonReversedReAmortizeTransaction(loan);
        if (reAmortizeTransaction == null) {
            // empty if block
        }
        if (loan.isProgressiveSchedule()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan);
        }
        this.reverseReAmortizeTransaction(reAmortizeTransaction, command);
        this.loanTransactionRepository.saveAndFlush((Object)reAmortizeTransaction);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAmortizeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAmortizeTransactionBusinessEvent(reAmortizeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAmortizeTransaction.getId()).withEntityExternalId(reAmortizeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    @Transactional(readOnly=true)
    public LoanScheduleData previewReAmortization(Long loanId, String loanExternalId, ReAmortizationPreviewRequest reAmortizationPreviewRequest) {
        Loan loan = loanId != null ? this.loanAssembler.assembleFrom(loanId) : this.loanAssembler.assembleFrom(ExternalIdFactory.produce((String)loanExternalId), false);
        return this.previewReAmortization(loan, reAmortizationPreviewRequest);
    }

    private LoanScheduleData previewReAmortization(Loan loan, ReAmortizationPreviewRequest reAmortizationPreviewRequest) {
        this.reAmortizationValidator.validateReAmortize(loan);
        LoanTransaction reAmortizeTransaction = this.createReAmortizeTransactionFromPreviewRequest(loan, reAmortizationPreviewRequest);
        this.processReAmortizationTransaction(loan, reAmortizeTransaction, false);
        loan.updateLoanScheduleDependentDerivedFields();
        CurrencyData currencyData = new CurrencyData(loan.getCurrencyCode(), null, loan.getCurrency().getDigitsAfterDecimal(), loan.getCurrency().getInMultiplesOf(), null, null);
        RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData = new RepaymentScheduleRelatedLoanData(loan.getDisbursementDate(), loan.getDisbursementDate(), currencyData, loan.getPrincipal().getAmount(), loan.getInArrearsTolerance().getAmount(), BigDecimal.ZERO);
        Collection disbursementData = this.loanReadPlatformService.retrieveLoanDisbursementDetails((Long)loan.getId());
        List capitalizedIncomeData = this.loanCapitalizedIncomeBalanceRepository.findRepaymentPeriodDataByLoanId((Long)loan.getId());
        List sortedInstallments = loan.getRepaymentScheduleInstallments().stream().sorted(Comparator.comparingInt(LoanRepaymentScheduleInstallment::getInstallmentNumber)).collect(Collectors.toList());
        return this.loanRepaymentScheduleService.extractLoanScheduleData(sortedInstallments, repaymentScheduleRelatedLoanData, disbursementData, (Collection)capitalizedIncomeData, loan.isInterestRecalculationEnabled(), loan.getLoanProductRelatedDetail().getLoanScheduleType());
    }

    private void reverseReAmortizeTransaction(LoanTransaction reAmortizeTransaction, JsonCommand command) {
        ExternalId reversalExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        Loan loan = reAmortizeTransaction.getLoan();
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loan, reAmortizeTransaction, "reversed");
        reAmortizeTransaction.reverse(reversalExternalId);
        reAmortizeTransaction.manuallyAdjustedOrReversed();
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
    }

    private LoanTransaction findLatestNonReversedReAmortizeTransaction(Loan loan) {
        return loan.getLoanTransactions().stream().filter(LoanTransaction::isNotReversed).filter(LoanTransaction::isReAmortize).max(Comparator.comparing(LoanTransaction::getTransactionDate)).orElse(null);
    }

    private LoanTransaction createReAmortizeTransaction(Loan loan, JsonCommand command) {
        ExternalId txExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        Money txPrincipal = loan.getTotalPrincipalOutstandingUntil(transactionDate);
        BigDecimal txPrincipalAmount = txPrincipal.getAmount();
        return new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.REAMORTIZE, transactionDate, txPrincipalAmount, txPrincipalAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, false, null, txExternalId);
    }

    private LoanTransaction createReAmortizeTransactionFromPreviewRequest(Loan loan, ReAmortizationPreviewRequest reAmortizationPreviewRequest) {
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        Money txPrincipal = loan.getTotalPrincipalOutstandingUntil(transactionDate);
        BigDecimal txPrincipalAmount = txPrincipal.getAmount();
        LoanTransaction reAmortizationTransaction = new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.REAMORTIZE, transactionDate, txPrincipalAmount, txPrincipalAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, false, null, null);
        LoanReAmortizationParameter reAmortizationParameter = this.createReAmortizationParameterFromPreviewRequest(reAmortizationTransaction, reAmortizationPreviewRequest);
        reAmortizationTransaction.setLoanReAmortizationParameter(reAmortizationParameter);
        return reAmortizationTransaction;
    }

    private LoanReAmortizationParameter createReAmortizationParameter(LoanTransaction reAmortizationTransaction, JsonCommand command) {
        LoanReAmortizationInterestHandlingType reAmortizationInterestHandlingType = (LoanReAmortizationInterestHandlingType)command.enumValueOfParameterNamed("reAmortizationInterestHandling", LoanReAmortizationInterestHandlingType.class);
        if (reAmortizationInterestHandlingType == null) {
            reAmortizationInterestHandlingType = LoanReAmortizationInterestHandlingType.DEFAULT;
        }
        CodeValue reasonCodeValue = null;
        if (command.parameterExists("reasonCodeValueId")) {
            reasonCodeValue = this.codeValueRepository.findByCodeNameAndId("ReAmortizationReasons", command.longValueOfParameterNamed("reasonCodeValueId"));
        }
        return new LoanReAmortizationParameter(reAmortizationTransaction, reAmortizationInterestHandlingType, reasonCodeValue);
    }

    private LoanReAmortizationParameter createReAmortizationParameterFromPreviewRequest(LoanTransaction reAmortizationTransaction, ReAmortizationPreviewRequest reAmortizationPreviewRequest) {
        LoanReAmortizationInterestHandlingType reAmortizationInterestHandlingType = LoanReAmortizationInterestHandlingType.valueOf((String)reAmortizationPreviewRequest.getReAmortizationInterestHandling());
        return new LoanReAmortizationParameter(reAmortizationTransaction, reAmortizationInterestHandlingType, null);
    }

    private void processReAmortizationTransaction(Loan loan, LoanTransaction reAmortizationTransaction, boolean withPostTransactionChecks) {
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan);
            if (withPostTransactionChecks) {
                this.reprocessLoanTransactionsService.reprocessTransactions(loan, List.of(reAmortizationTransaction));
            } else {
                this.reprocessLoanTransactionsService.reprocessTransactionsWithoutChecks(loan, List.of(reAmortizationTransaction));
            }
        } else {
            this.reprocessLoanTransactionsService.processLatestTransaction(reAmortizationTransaction, loan);
        }
    }

    @Generated
    public LoanReAmortizationService(LoanAssembler loanAssembler, LoanReAmortizationValidator reAmortizationValidator, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanTransactionRepository loanTransactionRepository, LoanChargeValidator loanChargeValidator, ReprocessLoanTransactionsService reprocessLoanTransactionsService, CodeValueRepository codeValueRepository, LoanScheduleService loanScheduleService, LoanRepaymentScheduleService loanRepaymentScheduleService, LoanReadPlatformService loanReadPlatformService, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository) {
        this.loanAssembler = loanAssembler;
        this.reAmortizationValidator = reAmortizationValidator;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanChargeValidator = loanChargeValidator;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.codeValueRepository = codeValueRepository;
        this.loanScheduleService = loanScheduleService;
        this.loanRepaymentScheduleService = loanRepaymentScheduleService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
    }
}

