/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanproduct.productmix.api;

import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanproduct.productmix.data.ProductMixData;
import org.apache.fineract.portfolio.loanproduct.productmix.data.ProductMixRequest;
import org.apache.fineract.portfolio.loanproduct.productmix.service.ProductMixReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/loanproducts/{productId}/productmix")
@Component
@Tag(name="Product Mix")
public class ProductMixApiResource {
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "PRODUCTMIX";
    private static final Set<String> PRODUCT_MIX_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("productId", "productName", "restrictedProducts", "allowedProducts", "productOptions"));
    private final PlatformSecurityContext context;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<ProductMixData> toApiJsonSerializer;
    private final ProductMixReadPlatformService productMixReadPlatformService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveTemplate(@PathParam(value="productId") Long productId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ProductMixData productMixData = this.productMixReadPlatformService.retrieveLoanProductMixDetails(productId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            Collection productOptions = this.loanProductReadPlatformService.retrieveAvailableLoanProductsForMix();
            productMixData = ProductMixData.withTemplateOptions((ProductMixData)productMixData, (Collection)productOptions);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)productMixData, PRODUCT_MIX_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult createProductMix(@PathParam(value="productId") Long productId, ProductMixRequest productMixRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createProductMix(productId).withJson(this.toApiJsonSerializer.serialize((Object)productMixRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult updateProductMix(@PathParam(value="productId") Long productId, ProductMixRequest productMixRequest) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateProductMix(productId).withJson(this.toApiJsonSerializer.serialize((Object)productMixRequest)).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public CommandProcessingResult deleteProductMix(@PathParam(value="productId") Long productId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteProductMix(productId).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    @Generated
    public ProductMixApiResource(PlatformSecurityContext context, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<ProductMixData> toApiJsonSerializer, ProductMixReadPlatformService productMixReadPlatformService, LoanProductReadPlatformService loanProductReadPlatformService) {
        this.context = context;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.productMixReadPlatformService = productMixReadPlatformService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
    }
}

