/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class DoubleDoubleArrayColumnIterator
implements Iterator<double[]> {
    private final double[][] array;
    private int columnIndex = 0;
    private int numColumns;

    public DoubleDoubleArrayColumnIterator(double[][] array) {
        Objects.requireNonNull(array);
        this.array = array;
        this.numColumns = Integer.MAX_VALUE;
        for (double[] row : array) {
            if (row.length >= this.numColumns) continue;
            this.numColumns = row.length;
        }
        if (this.numColumns == Integer.MAX_VALUE) {
            this.numColumns = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.columnIndex < this.numColumns;
    }

    @Override
    public double[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        double[] col = new double[this.array.length];
        for (int r = 0; r < this.array.length; ++r) {
            col[r] = this.array[r][this.columnIndex];
        }
        ++this.columnIndex;
        return col;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported for arrays");
    }
}

