/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.s3.analyticsaccelerator.ObjectClientConfiguration;
import software.amazon.s3.analyticsaccelerator.ObjectClientTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.ConfigurableTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.exceptions.ExceptionHandler;
import software.amazon.s3.analyticsaccelerator.request.Constants;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.ObjectClient;
import software.amazon.s3.analyticsaccelerator.request.ObjectContent;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.StreamAuditContext;
import software.amazon.s3.analyticsaccelerator.request.UserAgent;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class S3SdkObjectClient
implements ObjectClient {
    @NonNull
    private final S3AsyncClient s3AsyncClient;
    @NonNull
    private final Telemetry telemetry;
    @NonNull
    private final UserAgent userAgent;
    private final boolean closeAsyncClient;

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, boolean closeAsyncClient) {
        this(s3AsyncClient, ObjectClientConfiguration.DEFAULT, closeAsyncClient);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, @NonNull ObjectClientConfiguration objectClientConfiguration) {
        this(s3AsyncClient, objectClientConfiguration, true);
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
        if (objectClientConfiguration == null) {
            throw new NullPointerException("objectClientConfiguration is marked non-null but is null");
        }
    }

    public S3SdkObjectClient(@NonNull S3AsyncClient s3AsyncClient, @NonNull ObjectClientConfiguration objectClientConfiguration, boolean closeAsyncClient) {
        if (s3AsyncClient == null) {
            throw new NullPointerException("s3AsyncClient is marked non-null but is null");
        }
        if (objectClientConfiguration == null) {
            throw new NullPointerException("objectClientConfiguration is marked non-null but is null");
        }
        this.s3AsyncClient = s3AsyncClient;
        this.closeAsyncClient = closeAsyncClient;
        this.telemetry = new ConfigurableTelemetry(objectClientConfiguration.getTelemetryConfiguration());
        this.userAgent = new UserAgent();
        this.userAgent.prepend(objectClientConfiguration.getUserAgentPrefix());
    }

    @Override
    public void close() {
        if (this.closeAsyncClient) {
            this.s3AsyncClient.close();
        }
    }

    @Override
    public CompletableFuture<ObjectMetadata> headObject(HeadRequest headRequest, OpenStreamInformation openStreamInformation) {
        HeadObjectRequest.Builder builder = HeadObjectRequest.builder().bucket(headRequest.getS3Uri().getBucket()).key(headRequest.getS3Uri().getKey());
        AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder = AwsRequestOverrideConfiguration.builder();
        requestOverrideConfigurationBuilder.putHeader("User-Agent", this.userAgent.getUserAgent());
        if (openStreamInformation.getStreamAuditContext() != null) {
            this.attachStreamContextToExecutionAttributes(requestOverrideConfigurationBuilder, openStreamInformation.getStreamAuditContext());
        }
        builder.overrideConfiguration(requestOverrideConfigurationBuilder.build());
        if (openStreamInformation.getEncryptionSecrets() != null && openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().isPresent()) {
            String customerKey = openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().get();
            String customerKeyMd5 = openStreamInformation.getEncryptionSecrets().getSsecCustomerKeyMd5();
            builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(customerKey).sseCustomerKeyMD5(customerKeyMd5);
        }
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.head")).attribute(ObjectClientTelemetry.uri(headRequest.getS3Uri()))).build(), this.s3AsyncClient.headObject((HeadObjectRequest)builder.build()).thenApply(headObjectResponse -> ObjectMetadata.builder().contentLength(headObjectResponse.contentLength()).etag(headObjectResponse.eTag()).build())).exceptionally(this.handleException(headRequest.getS3Uri()));
    }

    @Override
    public CompletableFuture<ObjectContent> getObject(GetRequest getRequest, OpenStreamInformation openStreamInformation) {
        GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(getRequest.getS3Uri().getBucket()).ifMatch(getRequest.getEtag()).key(getRequest.getS3Uri().getKey());
        String range = getRequest.getRange().toHttpString();
        builder.range(range);
        AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder = (AwsRequestOverrideConfiguration.Builder)((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader("Referer", getRequest.getReferrer().toString())).putHeader("User-Agent", this.userAgent.getUserAgent());
        if (openStreamInformation.getStreamAuditContext() != null) {
            this.attachStreamContextToExecutionAttributes(requestOverrideConfigurationBuilder, openStreamInformation.getStreamAuditContext());
        }
        builder.overrideConfiguration(requestOverrideConfigurationBuilder.build());
        if (openStreamInformation.getEncryptionSecrets() != null && openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().isPresent()) {
            String customerKey = openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().get();
            String customerKeyMd5 = openStreamInformation.getEncryptionSecrets().getSsecCustomerKeyMd5();
            builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(customerKey).sseCustomerKeyMD5(customerKeyMd5);
        }
        return this.telemetry.measureCritical(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name("s3.client.get")).attribute(ObjectClientTelemetry.uri(getRequest.getS3Uri()))).attribute(ObjectClientTelemetry.rangeLength(getRequest.getRange()))).attribute(ObjectClientTelemetry.range(getRequest.getRange()))).build(), ((CompletableFuture)this.s3AsyncClient.getObject((GetObjectRequest)builder.build(), AsyncResponseTransformer.toBlockingInputStream()).thenApply(responseInputStream -> ObjectContent.builder().stream((InputStream)responseInputStream).build())).exceptionally(this.handleException(getRequest.getS3Uri())));
    }

    private <T> Function<Throwable, T> handleException(S3URI s3Uri) {
        return throwable -> {
            Throwable cause = Optional.ofNullable(throwable.getCause()).filter(t -> throwable instanceof CompletionException || throwable instanceof ExecutionException).orElse((Throwable)throwable);
            throw new UncheckedIOException(ExceptionHandler.toIOException(cause, s3Uri));
        };
    }

    private void attachStreamContextToExecutionAttributes(AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder, StreamAuditContext streamAuditContext) {
        ((AwsRequestOverrideConfiguration.Builder)requestOverrideConfigurationBuilder.putExecutionAttribute(Constants.SPAN_ID, (Object)streamAuditContext.getSpanId())).putExecutionAttribute(Constants.OPERATION_NAME, (Object)streamAuditContext.getOperationName());
    }

    @NonNull
    @Generated
    public S3AsyncClient getS3AsyncClient() {
        return this.s3AsyncClient;
    }
}

