/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.ObjectRange;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;

public final class VectoredReadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VectoredReadUtils.class);

    public static List<ObjectRange> validateAndSortRanges(List<ObjectRange> input, long objectLength) throws EOFException {
        List<ObjectRange> sortedRanges;
        Objects.requireNonNull(input, "Null input list");
        if (input.isEmpty()) {
            LOG.debug("Empty input list");
            return input;
        }
        if (input.size() == 1) {
            VectoredReadUtils.validateRangeRequest(input.get(0));
            sortedRanges = input;
        } else {
            sortedRanges = VectoredReadUtils.sortRangeList(input);
            ObjectRange prev = null;
            for (ObjectRange current : sortedRanges) {
                VectoredReadUtils.validateRangeRequest(current);
                if (prev != null) {
                    Preconditions.checkArgument(current.getOffset() >= prev.getOffset() + (long)prev.getLength(), "Overlapping ranges %s and %s", (Object)prev, (Object)current);
                }
                prev = current;
            }
        }
        ObjectRange last = sortedRanges.get(sortedRanges.size() - 1);
        if (last.getOffset() >= objectLength) {
            throw new EOFException("Range starts beyond the file length (" + objectLength + "): " + last);
        }
        if (last.getOffset() + (long)last.getLength() > objectLength) {
            throw new EOFException("Range extends beyond the file length (" + objectLength + "): " + last);
        }
        return sortedRanges;
    }

    public static ObjectRange validateRangeRequest(ObjectRange range) throws EOFException {
        Objects.requireNonNull(range, "range is null");
        Preconditions.checkArgument(range.getLength() >= 0, "length is negative in %s", (Object)range);
        if (range.getOffset() < 0L) {
            throw new EOFException("position is negative in range " + range);
        }
        return range;
    }

    public static List<ObjectRange> sortRangeList(List<ObjectRange> input) {
        ArrayList<ObjectRange> l = new ArrayList<ObjectRange>(input);
        l.sort(Comparator.comparingLong(ObjectRange::getOffset));
        return l;
    }
}

