/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.sforce.ws.MessageHandler;
import java.net.URL;

public class MessageCaptureHandler
implements MessageHandler {
    private static final ThreadLocal<ByteBuffer> requestBuffer = new ThreadLocal();
    private static final ThreadLocal<ByteBuffer> responseBuffer = new ThreadLocal();

    @Override
    public void handleRequest(URL endpoint, byte[] request) {
        requestBuffer.set(new ByteBuffer(request));
    }

    @Override
    public void handleResponse(URL endpoint, byte[] response) {
        responseBuffer.set(new ByteBuffer(response));
    }

    protected String getRequestString() {
        ByteBuffer buffer = requestBuffer.get();
        return this.getString(buffer);
    }

    private String getString(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.array == null) {
            return "No Content";
        }
        return new String(byteBuffer.array);
    }

    protected String getResponseString() {
        ByteBuffer buffer = responseBuffer.get();
        return this.getString(buffer);
    }

    private static class ByteBuffer {
        public final byte[] array;

        ByteBuffer(byte[] array) {
            this.array = array;
        }
    }
}

