/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

public class JobQueueListFilter {
    public static final String ALL = "*ALL";
    public static final String JOB_QUEUE_ALLOCATED = "*ALLOCATED";
    public static final String JOB_QUEUE_DEFINED = "*DEFINED";
    public static final String JOB_QUEUE_LIBRARY_ALL_USER = "*ALLUSR";
    public static final String JOB_QUEUE_LIBRARY_CURRENT_LIBRARY = "*CURLIB";
    public static final String JOB_QUEUE_LIBRARY_LIBRARY_LIST = "*LIBL";
    public static final String JOB_QUEUE_LIBRARY_USER_LIBRARY = "*USRLIBL";
    public static final JobQueueListFilter DEFAULT = new JobQueueListFilter("*ALL", "*ALL", null);
    private String activeSubsystemName;
    private String jobQueueName;
    private String jobQueueLibraryName;

    public JobQueueListFilter(String jobQueueName, String jobQueueLibraryName, String activeSubsystemName) {
        this.activeSubsystemName = activeSubsystemName;
        this.jobQueueLibraryName = jobQueueLibraryName;
        this.jobQueueName = jobQueueName;
    }

    public static JobQueueListFilter forAllAllocated() {
        return new JobQueueListFilter(JOB_QUEUE_ALLOCATED, null, ALL);
    }

    public static JobQueueListFilter forSubsystem(String subsystemName, boolean allocatedOnly) {
        return new JobQueueListFilter(allocatedOnly ? JOB_QUEUE_ALLOCATED : JOB_QUEUE_DEFINED, null, subsystemName);
    }

    public static JobQueueListFilter forJobQueue(String jobQueueName) {
        return JobQueueListFilter.forJobQueue(jobQueueName, ALL);
    }

    public static JobQueueListFilter forJobQueue(String jobQueueName, String jobQueueLibraryName) {
        return new JobQueueListFilter(jobQueueName, jobQueueLibraryName, null);
    }

    public String getActiveSubsystemName() {
        return this.activeSubsystemName;
    }

    public String getJobQueueName() {
        return this.jobQueueName;
    }

    public String getJobQueueLibraryName() {
        return this.jobQueueLibraryName;
    }
}

